/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.net.ssl.SSLHandshakeException;
import org.json.JSONObject;
import uk.betacraft.legacyfix.LFLogger;
import uk.betacraft.util.Request;
import uk.betacraft.util.WebData;

public class RequestUtil {
    public static String webDataToString(WebData data) {
        if (data.getData() != null) {
            try {
                return new String(data.getData(), "UTF-8");
            }
            catch (Throwable t) {
                LFLogger.error("webDataToString", t);
            }
        }
        return null;
    }

    public static String performPOSTRequest(Request req) {
        WebData data = RequestUtil.performRawPOSTRequest(req);
        return RequestUtil.webDataToString(data);
    }

    public static WebData performRawPOSTRequest(Request req) {
        try {
            URL url = new URL(req.REQUEST_URL);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setReadTimeout(15000);
            con.setConnectTimeout(15000);
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            for (String key : req.PROPERTIES.keySet()) {
                con.addRequestProperty(key, req.PROPERTIES.get(key));
            }
            DataOutputStream out = new DataOutputStream(con.getOutputStream());
            if (req.POST_DATA != null) {
                out.write(req.POST_DATA.getBytes("UTF-8"));
            }
            out.flush();
            out.close();
            int http = con.getResponseCode();
            byte[] data = http >= 400 && http < 600 ? RequestUtil.readInputStream(con.getErrorStream()) : RequestUtil.readInputStream(con.getInputStream());
            return new WebData(data, http);
        }
        catch (SSLHandshakeException e) {
            LFLogger.error("performRawPOSTRequest", (Throwable)e);
            return new WebData(null, -2);
        }
        catch (Throwable t) {
            LFLogger.error("performRawPOSTRequest", t);
            return new WebData(null, -1);
        }
    }

    public static String performGETRequest(Request req) {
        WebData data = RequestUtil.performRawGETRequest(req);
        return RequestUtil.webDataToString(data);
    }

    public static WebData performRawGETRequest(Request req) {
        try {
            URL url = new URL(req.REQUEST_URL);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setReadTimeout(15000);
            con.setConnectTimeout(15000);
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.addRequestProperty("User-agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36");
            for (String key : req.PROPERTIES.keySet()) {
                con.addRequestProperty(key, req.PROPERTIES.get(key));
            }
            int http = con.getResponseCode();
            byte[] data = http >= 400 && http < 600 ? RequestUtil.readInputStream(con.getErrorStream()) : RequestUtil.readInputStream(con.getInputStream());
            return new WebData(data, http);
        }
        catch (SSLHandshakeException e) {
            LFLogger.error("performRawGETRequest", (Throwable)e);
            return new WebData(null, -2);
        }
        catch (Throwable t) {
            LFLogger.error("performRawGETRequest", t);
            return new WebData(null, -1);
        }
    }

    public static boolean download(Request req, File destination) {
        try {
            int bytesRead;
            URL url = new URL(req.REQUEST_URL);
            BufferedInputStream bin = new BufferedInputStream(url.openStream());
            FileOutputStream fos = new FileOutputStream(destination);
            byte[] buffer = new byte[1024];
            while ((bytesRead = bin.read(buffer, 0, 1024)) != -1) {
                fos.write(buffer, 0, bytesRead);
            }
            bin.close();
            fos.close();
            return true;
        }
        catch (Throwable t) {
            LFLogger.error("download", t);
            return false;
        }
    }

    public static WebData performJoinServer(String uuid, String sessionId, String serverId) {
        String accessToken = sessionId.contains(":") ? sessionId.split(":")[1] : sessionId;
        return RequestUtil.performRawPOSTRequest(new Request().setUrl("https://sessionserver.mojang.com/session/minecraft/join").setHeader("Content-Type", "application/json").setPayload(new JSONObject().put("serverId", serverId).put("accessToken", accessToken).put("selectedProfile", uuid)));
    }

    public static String getIPFromAmazon() {
        try {
            URL amazonUrl = new URL("http://checkip.amazonaws.com");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(amazonUrl.openStream()));
            return bufferedReader.readLine();
        }
        catch (Throwable t) {
            LFLogger.error("Failed to get IP from checkip.amazonaws.com, user is probably offline");
            LFLogger.error("getIPFromAmazon", t);
            return null;
        }
    }

    public static byte[] readInputStream(InputStream in) {
        try {
            int count;
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((count = in.read(buffer)) > 0) {
                baos.write(buffer, 0, count);
            }
            return baos.toByteArray();
        }
        catch (Throwable t) {
            LFLogger.error("readInputStream", t);
            return null;
        }
    }
}

