/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix.util;

import java.io.ByteArrayInputStream;
import uk.betacraft.legacyfix.LFLogger;
import uk.betacraft.legacyfix.util.ImageUtils;
import uk.betacraft.legacyfix.util.MinecraftAPIUtils;

public class SkinUtils {
    public static final boolean OVERLAY_OUTER_HEAD_LAYER = System.getProperties().containsKey("lf.OVERLAY_OUTER_HEAD_LAYER");
    public static final boolean OVERLAY_OUTER_BODY_TO_BASE = System.getProperties().containsKey("lf.OVERLAY_OUTER_BODY_TO_BASE");
    public static final boolean ROTATE_BOTTOM_TEXTURES = System.getProperties().containsKey("lf.ROTATE_BOTTOM_TEXTURES");
    public static final boolean CONVERT_ALEX_TO_STEVE = System.getProperties().containsKey("lf.CONVERT_ALEX_TO_STEVE");
    public static final boolean SERVE_AS_64x32 = System.getProperties().containsKey("lf.SERVE_AS_64x32");

    public static byte[] getFixedCape(MinecraftAPIUtils.SkinData skinData) {
        try {
            if (skinData.cape != null) {
                ByteArrayInputStream bis = new ByteArrayInputStream(skinData.cape);
                ImageUtils img = new ImageUtils(bis);
                return img.crop(0, 0, 64, 32).getInByteForm();
            }
        }
        catch (Throwable t) {
            LFLogger.error("getFixedCape", t);
        }
        return null;
    }

    public static byte[] getFixedSkin(MinecraftAPIUtils.SkinData skinData) {
        try {
            if (skinData.skin != null) {
                ByteArrayInputStream bis = new ByteArrayInputStream(skinData.skin);
                ImageUtils img = new ImageUtils(bis);
                if (OVERLAY_OUTER_HEAD_LAYER) {
                    img = SkinUtils.overlayHeadLayer(img);
                }
                if (OVERLAY_OUTER_BODY_TO_BASE && img.getImage().getHeight() == 64) {
                    img = SkinUtils.overlay64to32(img);
                }
                if (CONVERT_ALEX_TO_STEVE && skinData.alex) {
                    SkinUtils.alexToSteve(img);
                }
                if (ROTATE_BOTTOM_TEXTURES) {
                    SkinUtils.rotateBottomTX(img);
                }
                if (SERVE_AS_64x32) {
                    img = img.crop(0, 0, 64, 32);
                }
                return img.getInByteForm();
            }
        }
        catch (Throwable t) {
            LFLogger.error("getFixedSkin", t);
        }
        return null;
    }

    public static void rotateBottomTX(ImageUtils img) {
        img.setArea(16, 0, img.crop(16, 0, 8, 8).flip(false, true).getImage());
        img.setArea(48, 0, img.crop(48, 0, 8, 8).flip(false, true).getImage());
        img.setArea(8, 16, img.crop(8, 16, 4, 4).flip(false, true).getImage());
        img.setArea(48, 16, img.crop(48, 16, 4, 4).flip(false, true).getImage());
        img.setArea(28, 16, img.crop(28, 16, 8, 4).flip(false, true).getImage());
    }

    public static ImageUtils overlay64to32(ImageUtils img) {
        return img.setArea(0, 16, img.crop(0, 32, 56, 16).getImage(), false);
    }

    public static ImageUtils overlayHeadLayer(ImageUtils img) {
        return img.setArea(0, 0, img.crop(32, 0, 32, 16).getImage(), false);
    }

    public static void alexToSteve(ImageUtils img) {
        img.setArea(48, 20, img.crop(47, 20, 7, 12).getImage());
        img.setArea(47, 20, img.crop(46, 20, 1, 12).getImage());
        img.setArea(55, 20, img.crop(54, 20, 1, 12).getImage());
        img.setArea(48, 16, img.crop(47, 16, 3, 4).getImage());
        img.setArea(47, 16, img.crop(46, 16, 1, 4).getImage());
        img.setArea(51, 16, img.crop(50, 16, 1, 4).getImage());
    }
}

