/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix.util;

import java.lang.management.ManagementFactory;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JvmUtils {
    private static final int jvmVersion = JvmUtils.fetchJvmVersion();

    public static String getJvmArguments() {
        String name = System.getProperty("java.vm.name");
        return (JvmUtils.contains(name, "Server") ? "-server " : (JvmUtils.contains(name, "Client") ? "-client " : "")) + JvmUtils.join(" ", ManagementFactory.getRuntimeMXBean().getInputArguments());
    }

    static boolean contains(String s, String b) {
        return s != null && s.contains(b);
    }

    static String join(String glue, Iterable<String> strings) {
        if (strings == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        Iterator<String> i = strings.iterator();
        if (i.hasNext()) {
            buf.append(i.next());
            while (i.hasNext()) {
                buf.append(glue).append(i.next());
            }
        }
        return buf.toString();
    }

    private static int fetchJvmVersion() {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.startsWith("1.")) {
            javaVersion = javaVersion.substring(2, 3);
        } else {
            int dot = javaVersion.indexOf(".");
            if (dot != -1) {
                javaVersion = javaVersion.substring(0, dot);
            }
        }
        try {
            return Integer.parseInt(javaVersion);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static int getJvmVersion() {
        return jvmVersion;
    }
}

