/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix.protocol.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import uk.betacraft.legacyfix.LFLogger;
import uk.betacraft.legacyfix.LegacyFixLauncher;
import uk.betacraft.legacyfix.protocol.impl.LevelHandlerBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevelListHandler
extends LevelHandlerBase {
    private static final Pattern LEVEL_LIST_PATTERN = Pattern.compile("(http:\\/\\/(www\\.)?minecraft\\.net(:(.+)?)?\\/listmaps\\.jsp\\?user=(.+)?)");
    protected static final String LEVELS_DIR_PATH = System.getProperty("lf.levelDir", LegacyFixLauncher.getGameDir() + "/levels");
    public static final String EMPTY_LEVEL = "-";

    public LevelListHandler(URL u, Pattern patternUsed) {
        super(u, patternUsed);
        this.prepare();
    }

    private void prepare() {
        String levels = "";
        for (int i = 0; i < 5; ++i) {
            levels = levels + "-;";
        }
        File levelsFolder = new File(LEVELS_DIR_PATH);
        File levelNames = new File(levelsFolder, "levels.txt");
        if (!levelNames.exists()) {
            this.inputStream = new ByteArrayInputStream(levels.getBytes());
        } else {
            try {
                this.inputStream = new FileInputStream(levelNames);
            }
            catch (FileNotFoundException e) {
                LFLogger.error("File not found but exists?");
                LFLogger.error("LevelListHandler.prepare", (Throwable)e);
            }
        }
    }

    public static List<Pattern> regexPatterns() {
        return Arrays.asList(LEVEL_LIST_PATTERN);
    }
}

