/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix.patch.impl;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import javassist.CannotCompileException;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.expr.ExprEditor;
import javassist.expr.MethodCall;
import uk.betacraft.legacyfix.LFLogger;
import uk.betacraft.legacyfix.patch.Patch;
import uk.betacraft.legacyfix.patch.PatchException;
import uk.betacraft.legacyfix.patch.PatchHelper;

public class ClassicIndevResizePatch
extends Patch {
    public ClassicIndevResizePatch() {
        super("classic-indev-resize", "Fixes resizing in Classic versions", true);
    }

    public void apply(Instrumentation inst) throws Exception {
        String screenFieldName;
        CtClass minecraftClass = PatchHelper.findMinecraftClass(pool);
        for (CtMethod method : minecraftClass.getDeclaredMethods()) {
            if (!this.hasDesktopDisplayModeCall(method)) continue;
            throw new PatchException("Detected version past in-20100110, patch won't be applied");
        }
        CtMethod runMethod = minecraftClass.getDeclaredMethod("run");
        CtField[] fields = minecraftClass.getDeclaredFields();
        CtField width = null;
        CtField height = null;
        for (int i = 0; i < fields.length - 2; ++i) {
            if (!fields[i].getType().equals(CtClass.booleanType) || !fields[i + 1].getType().equals(CtClass.intType) || !fields[i + 2].getType().equals(CtClass.intType)) continue;
            width = fields[i + 1];
            height = fields[i + 2];
            break;
        }
        if (width == null || height == null) {
            throw new PatchException("Game width / height fields were not found");
        }
        CtField screenField = this.findScreen();
        final CtMethod initMethod = this.findInitMethod(screenField);
        this.patchPauseScreen(inst);
        final String widthFieldName = width.getName();
        final String heightFieldName = height.getName();
        String string = screenFieldName = screenField == null ? null : screenField.getName();
        if (minecraftClass.isFrozen()) {
            minecraftClass.defrost();
        }
        runMethod.instrument(new ExprEditor(){
            final String thisWidth;
            final String thisHeight;
            final String thisScreen;
            {
                this.thisWidth = "this." + widthFieldName;
                this.thisHeight = "this." + heightFieldName;
                this.thisScreen = screenFieldName != null ? "this." + screenFieldName : "";
            }

            public void edit(MethodCall m) throws CannotCompileException {
                if (m.getClassName().equals("org.lwjgl.opengl.Display") && m.getMethodName().equals("isCloseRequested")) {
                    m.replace("{     int lastWidth = " + this.thisWidth + ";    int lastHeight = " + this.thisHeight + ";    " + this.thisWidth + " = org.lwjgl.opengl.Display.getWidth();    " + this.thisHeight + " = org.lwjgl.opengl.Display.getHeight();" + (screenFieldName != null && initMethod != null ? "    if (" + this.thisScreen + " != null && (" + this.thisWidth + " != lastWidth || " + this.thisHeight + " != lastHeight)) {        " + this.thisScreen + "." + initMethod.getName() + "(this, " + this.thisWidth + " * 240 /" + this.thisHeight + ", " + this.thisHeight + " * 240 /" + this.thisHeight + ");    }" : "") + "    $_ = $proceed($$);}");
                }
            }
        });
        this.patchHud(inst, this.findHudField(), width, height);
        inst.redefineClasses(new ClassDefinition(Class.forName(minecraftClass.getName()), minecraftClass.toBytecode()));
    }

    private boolean hasDesktopDisplayModeCall(CtMethod method) {
        try {
            CodeAttribute codeAttribute = method.getMethodInfo().getCodeAttribute();
            CodeIterator codeIterator = codeAttribute.iterator();
            ConstPool cp = method.getMethodInfo().getConstPool();
            while (codeIterator.hasNext()) {
                String refName;
                int pos = codeIterator.next();
                if (codeIterator.byteAt(pos) != 153 || codeIterator.byteAt(pos + 3) != 184 || codeIterator.byteAt(pos + 6) != 184 || codeIterator.byteAt(pos + 9) != 42 || !"getDesktopDisplayMode".equals(refName = cp.getMethodrefName(codeIterator.u16bitAt(pos + 4)))) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private CtField findScreen() {
        try {
            CtClass minecraftClass = PatchHelper.findMinecraftClass(pool);
            CtField[] mcFields = minecraftClass.getDeclaredFields();
            CtField screenField = null;
            for (CtField curr : mcFields) {
                if (curr.getType().isPrimitive()) continue;
                CtClass candidate = curr.getType();
                int countMinecraft = 0;
                int countInt = 0;
                for (CtField field : candidate.getDeclaredFields()) {
                    if (!Modifier.isProtected(field.getModifiers())) continue;
                    if (field.getType().equals(minecraftClass)) {
                        ++countMinecraft;
                        continue;
                    }
                    if (!field.getType().equals(CtClass.intType)) continue;
                    ++countInt;
                }
                if (countMinecraft != true || countInt != 2) continue;
                screenField = curr;
                LFLogger.debug("Found Screen class: " + candidate.getName());
                LFLogger.debug("Found Screen field: " + screenField.getName());
                break;
            }
            return screenField;
        }
        catch (Exception e) {
            return null;
        }
    }

    private CtMethod findInitMethod(CtField screenField) {
        try {
            if (screenField == null) {
                return null;
            }
            CtClass minecraftClass = PatchHelper.findMinecraftClass(pool);
            CtClass screenClass = screenField.getType();
            for (CtMethod method : screenClass.getDeclaredMethods()) {
                CtClass[] parameters = method.getParameterTypes();
                if (parameters.length != 3 || parameters[0] != minecraftClass || parameters[1] != CtClass.intType || parameters[2] != CtClass.intType) continue;
                LFLogger.debug("Found init method: " + method.getName());
                return method;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private void patchPauseScreen(Instrumentation inst) {
        try {
            CtClass pauseScreen = pool.get("com.mojang.minecraft.gui.PauseScreen");
            CtField buttonsField = pauseScreen.getDeclaredField("buttons");
            CtMethod initMethod = pauseScreen.getDeclaredMethod("init", null);
            if (pauseScreen.isFrozen()) {
                pauseScreen.defrost();
            }
            initMethod.insertBefore("this." + buttonsField.getName() + " = new java.util.ArrayList();");
            inst.redefineClasses(new ClassDefinition(Class.forName(pauseScreen.getName()), pauseScreen.toBytecode()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private CtField findHudField() {
        try {
            CtClass minecraftClass = PatchHelper.findMinecraftClass(pool);
            CtMethod runMethod = minecraftClass.getDeclaredMethod("run");
            CodeAttribute codeAttribute = runMethod.getMethodInfo().getCodeAttribute();
            CodeIterator codeIterator = codeAttribute.iterator();
            ConstPool cp = runMethod.getMethodInfo().getConstPool();
            while (codeIterator.hasNext()) {
                int aloadIndex;
                int ldcIndex;
                int pos = codeIterator.next();
                int opcode = codeIterator.byteAt(pos);
                if (opcode != 18 || cp.getTag(ldcIndex = codeIterator.byteAt(pos + 1)) != 8 || !"Post startup".equals(cp.getStringInfo(ldcIndex))) continue;
                int posInvoke = pos + 2;
                if (!codeIterator.hasNext() || codeIterator.byteAt(posInvoke) != 184) continue;
                int posAload = posInvoke + 3;
                if (!codeIterator.hasNext() || codeIterator.byteAt(posAload) != 25 || (aloadIndex = codeIterator.byteAt(posAload + 1)) != 4) continue;
                int posNew = posAload + 2;
                if (!codeIterator.hasNext() || codeIterator.byteAt(posNew) != 187) continue;
                int newIndex = codeIterator.u16bitAt(posNew + 1);
                String newClassName = cp.getClassInfo(newIndex);
                String normalizedNewClass = newClassName.replace('/', '.');
                while (codeIterator.hasNext()) {
                    int fieldIndex;
                    String fieldDescriptor;
                    String fieldType;
                    String normalizedFieldType;
                    int currPos = codeIterator.next();
                    if (codeIterator.byteAt(currPos) != 181 || !normalizedNewClass.equals(normalizedFieldType = (fieldType = (fieldDescriptor = cp.getFieldrefType(fieldIndex = codeIterator.u16bitAt(currPos + 1))).startsWith("L") && fieldDescriptor.endsWith(";") ? fieldDescriptor.substring(1, fieldDescriptor.length() - 1) : fieldDescriptor).replace('/', '.'))) continue;
                    String fieldName = cp.getFieldrefName(fieldIndex);
                    LFLogger.debug("Found field HUD: " + fieldName);
                    return minecraftClass.getDeclaredField(fieldName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void patchHud(Instrumentation inst, CtField hudField, CtField widthField, CtField heightField) {
        if (hudField == null) {
            return;
        }
        try {
            CtClass minecraftClass = PatchHelper.findMinecraftClass(pool);
            CtClass hudClass = hudField.getType();
            CtBehavior renderMethod = null;
            for (CtMethod ctMethod : hudClass.getDeclaredMethods()) {
                CtClass[] params;
                if (!Modifier.isPublic(ctMethod.getModifiers()) || !Modifier.isFinal(ctMethod.getModifiers()) || !ctMethod.getReturnType().equals(CtClass.voidType) || (params = ctMethod.getParameterTypes()).length != 0 && (params.length != 3 || !params[0].equals(CtClass.booleanType) || !params[1].equals(CtClass.intType) || !params[2].equals(CtClass.intType)) && (params.length != 4 || !params[0].equals(CtClass.floatType) || !params[1].equals(CtClass.booleanType) || !params[2].equals(CtClass.intType) || !params[3].equals(CtClass.intType))) continue;
                renderMethod = ctMethod;
                break;
            }
            if (renderMethod == null) {
                return;
            }
            LFLogger.debug("Found hud method: " + renderMethod.getSignature());
            CtField minecraft = null;
            CtField width = null;
            CtField height = null;
            for (CtField field : hudClass.getDeclaredFields()) {
                if (field.getType().equals(minecraftClass)) {
                    minecraft = field;
                }
                if (!field.getType().equals(CtClass.intType)) continue;
                if (width == null) {
                    width = field;
                    continue;
                }
                if (height != null) continue;
                height = field;
            }
            if (minecraft == null || width == null || height == null) {
                return;
            }
            if (hudClass.isFrozen()) {
                hudClass.defrost();
            }
            String string = minecraft.getName() + "." + widthField.getName();
            String minecraftHeight = minecraft.getName() + "." + heightField.getName();
            renderMethod.insertBefore("$0." + width.getName() + " = $0." + string + " * 240 / " + minecraftHeight + ";$0." + height.getName() + " = $0." + minecraftHeight + " * 240 / " + minecraftHeight + ";");
            inst.redefineClasses(new ClassDefinition(Class.forName(hudClass.getName()), hudClass.toBytecode()));
        }
        catch (Exception e) {
            LFLogger.error("patchHud", (Throwable)e);
        }
    }

    public boolean shouldApply() {
        return super.shouldApply() && (pool.getOrNull("com.mojang.minecraft.MinecraftApplet") != null || pool.getOrNull("net.minecraft.client.MinecraftApplet") != null);
    }
}

