/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.legacyfix.patch;

import java.lang.instrument.Instrumentation;
import javassist.ClassPool;
import uk.betacraft.legacyfix.LegacyFixAgent;
import uk.betacraft.legacyfix.patch.PatchException;

public abstract class Patch {
    private final String id;
    private final String description;
    private final Object setting;
    private final boolean isDefault;
    private final boolean isRequired;
    protected static final ClassPool pool = ClassPool.getDefault();

    public Patch(String id, String description, boolean isDefault, boolean isRequired) {
        this.id = id;
        this.description = description;
        this.isDefault = isDefault;
        this.isRequired = false;
        this.setting = LegacyFixAgent.getSettings().get("lf." + this.getId() + (isDefault ? ".disable" : ""));
    }

    public Patch(String id, String description, boolean isDefault) {
        this(id, description, isDefault, false);
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public boolean shouldApply() {
        return this.isRequired || (this.isDefault ? this.setting == null : this.setting != null);
    }

    public abstract void apply(Instrumentation var1) throws PatchException, Exception;
}

