/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator.opengl;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.lwjgl.util.generator.Alias;
import org.lwjgl.util.generator.Alternate;
import org.lwjgl.util.generator.Dependent;
import org.lwjgl.util.generator.ForceInit;
import org.lwjgl.util.generator.Optional;
import org.lwjgl.util.generator.Platform;
import org.lwjgl.util.generator.PlatformDependent;
import org.lwjgl.util.generator.Reuse;
import org.lwjgl.util.generator.Utils;

public class GLESCapabilitiesGenerator {
    private static final String STUBS_LOADED_NAME = "loaded_stubs";
    private static final String ALL_INIT_METHOD_NAME = "initAllStubs";
    private static final String POINTER_INITIALIZER_POSTFIX = "_initNativeFunctionAddresses";
    private static final String CACHED_EXTS_VAR_NAME = "supported_extensions";
    private static final String EXTENSION_PREFIX = "GL_";
    private static final String CORE_PREFIX = "Open";

    public static void generateClassPrologue(PrintWriter writer, boolean context_specific, boolean generate_error_checks) {
        writer.println("public class ContextCapabilities {");
        writer.println("\tstatic final boolean DEBUG = " + Boolean.toString(generate_error_checks) + ";");
        writer.println();
        if (!context_specific) {
            writer.println("\tprivate static boolean loaded_stubs;");
        }
    }

    public static void generateInitializerPrologue(PrintWriter writer) {
        writer.println("\tContextCapabilities() throws LWJGLException {");
        writer.println("\t\tSet<String> supported_extensions = initAllStubs();");
    }

    private static String translateFieldName(String interface_name) {
        if (interface_name.startsWith("GL")) {
            return CORE_PREFIX + interface_name;
        }
        return EXTENSION_PREFIX + interface_name;
    }

    public static void generateSuperClassAdds(PrintWriter writer, TypeElement d, ProcessingEnvironment env) {
        List<? extends TypeMirror> super_interfaces = d.getInterfaces();
        if (super_interfaces.size() > 1) {
            throw new RuntimeException(d + " extends more than one other interface");
        }
        if (super_interfaces.size() == 1) {
            TypeMirror super_interface = super_interfaces.iterator().next();
            writer.print("\t\tif (supported_extensions.contains(\"");
            writer.println(GLESCapabilitiesGenerator.translateFieldName(d.getSimpleName().toString() + "\"))"));
            writer.print("\t\t\t");
            GLESCapabilitiesGenerator.generateAddExtension(writer, env.getElementUtils().getTypeElement(super_interface.toString()));
        }
    }

    public static void generateInitializer(PrintWriter writer, TypeElement d, ProcessingEnvironment env) {
        Alias alias_annotation;
        String translated_field_name = GLESCapabilitiesGenerator.translateFieldName(d.getSimpleName().toString());
        writer.print("\t\tthis." + translated_field_name + " = ");
        writer.print("supported_extensions.contains(\"");
        writer.print(translated_field_name + "\")");
        List<? extends TypeMirror> super_interfaces = d.getInterfaces();
        if (super_interfaces.size() > 1) {
            throw new RuntimeException(d + " extends more than one other interface");
        }
        if (super_interfaces.size() == 1) {
            TypeMirror super_interface = super_interfaces.iterator().next();
            writer.println();
            writer.print("\t\t\t&& supported_extensions.contains(\"");
            writer.print(GLESCapabilitiesGenerator.translateFieldName(env.getElementUtils().getTypeElement(super_interface.toString()).getSimpleName() + "\")"));
        }
        if ((alias_annotation = d.getAnnotation(Alias.class)) != null) {
            writer.println();
            writer.print("\t\t\t|| supported_extensions.contains(\"");
            writer.print(GLESCapabilitiesGenerator.translateFieldName(alias_annotation.value()) + "\")");
        }
        writer.println(";");
    }

    private static String getAddressesInitializerName(String class_name) {
        return class_name + POINTER_INITIALIZER_POSTFIX;
    }

    public static void generateInitStubsPrologue(PrintWriter writer, boolean context_specific) {
        writer.println("\tprivate Set<String> initAllStubs() throws LWJGLException {");
        if (context_specific) {
            writer.println("\t\tglGetError = GLContext.getFunctionAddress(\"glGetError\");");
            writer.println("\t\tglGetString = GLContext.getFunctionAddress(\"glGetString\");");
        }
        writer.println("\t\tGLContext.setCapabilities(this);");
        writer.println("\t\tSet<String> supported_extensions = new HashSet<String>(256);");
        if (!context_specific) {
            writer.println("\t\tGLContext.doInitNativeStubs(GLES20.class);");
        }
        writer.println("\t\tGLContext.getSupportedExtensions(supported_extensions);");
        if (!context_specific) {
            writer.println("\t\tif (loaded_stubs)");
            writer.println("\t\t\treturn supported_extensions;");
        } else {
            writer.println("\t\tif (!" + GLESCapabilitiesGenerator.getAddressesInitializerName("GLES20") + "())");
            writer.println("\t\t\tthrow new LWJGLException(\"GL ES 2.0 not supported\");");
        }
    }

    public static void generateInitStubsEpilogue(PrintWriter writer, boolean context_specific) {
        if (!context_specific) {
            writer.println("\t\tloaded_stubs = true;");
        }
        writer.println("\t\treturn supported_extensions;");
        writer.println("\t}");
    }

    public static void generateUnloadStubs(ProcessingEnvironment env, PrintWriter writer, TypeElement d) {
        if (Utils.getMethods(d).size() > 0 && !d.getSimpleName().toString().startsWith("GLES")) {
            writer.print("\t\tGLContext.resetNativeStubs(" + Utils.getSimpleClassName(d));
            writer.println(".class);");
        }
    }

    public static void generateInitStubs(ProcessingEnvironment env, PrintWriter writer, TypeElement d, boolean context_specific) {
        if (Utils.getMethods(d).size() > 0) {
            if (context_specific) {
                Alias alias_annotation = d.getAnnotation(Alias.class);
                if (d.getAnnotation(ForceInit.class) != null) {
                    writer.println("\t\tsupported_extensions.add(\"" + GLESCapabilitiesGenerator.translateFieldName(d.getSimpleName().toString()) + "\");");
                }
                writer.print("\t\tif (");
                if (alias_annotation != null) {
                    writer.print("(");
                }
                writer.print("supported_extensions.contains(\"");
                writer.print(GLESCapabilitiesGenerator.translateFieldName(d.getSimpleName().toString()) + "\")");
                if (alias_annotation != null) {
                    writer.print(" || supported_extensions.contains(\"");
                    writer.print(GLESCapabilitiesGenerator.translateFieldName(alias_annotation.value()) + "\"))");
                }
                writer.print(" && !" + GLESCapabilitiesGenerator.getAddressesInitializerName(d.getSimpleName().toString()) + "(");
                if (d.getAnnotation(Dependent.class) != null) {
                    writer.print(CACHED_EXTS_VAR_NAME);
                }
                if (alias_annotation != null) {
                    writer.println(")) {");
                    writer.print("\t\t\tremove(supported_extensions, \"");
                    writer.println(GLESCapabilitiesGenerator.translateFieldName(alias_annotation.value()) + "\");");
                } else {
                    writer.println("))");
                }
                writer.print("\t\t\tremove(supported_extensions, \"");
                writer.println(GLESCapabilitiesGenerator.translateFieldName(d.getSimpleName().toString()) + "\");");
                if (alias_annotation != null) {
                    writer.println("\t\t}");
                }
            } else {
                writer.print("\t\tGLContext.initNativeStubs(" + Utils.getSimpleClassName(d));
                writer.println(".class, supported_extensions, \"" + GLESCapabilitiesGenerator.translateFieldName(d.getSimpleName().toString()) + "\");");
            }
        }
    }

    private static void generateAddExtension(PrintWriter writer, TypeElement d) {
        writer.print("supported_extensions.add(\"");
        writer.println(GLESCapabilitiesGenerator.translateFieldName(d.getSimpleName().toString()) + "\");");
    }

    public static void generateAddressesInitializers(ProcessingEnvironment env, PrintWriter writer, TypeElement d) {
        Alias alias_annotation;
        Iterator<ExecutableElement> methods = Utils.getMethods(d).iterator();
        if (!methods.hasNext()) {
            return;
        }
        writer.print("\tprivate boolean " + GLESCapabilitiesGenerator.getAddressesInitializerName(d.getSimpleName().toString()) + "(");
        Dependent dependent = d.getAnnotation(Dependent.class);
        if (dependent != null) {
            writer.print("Set<String> supported_extensions");
        }
        boolean aliased = (alias_annotation = d.getAnnotation(Alias.class)) != null && alias_annotation.postfix().length() > 0;
        writer.println(") {");
        writer.println("\t\treturn ");
        boolean first = true;
        while (methods.hasNext()) {
            ExecutableElement method = methods.next();
            if (method.getAnnotation(Alternate.class) != null) continue;
            if (!first) {
                writer.println(" &");
            } else {
                first = false;
            }
            boolean optional = method.getAnnotation(Optional.class) != null;
            dependent = method.getAnnotation(Dependent.class);
            writer.print("\t\t\t(");
            if (optional) {
                writer.print('(');
            }
            if (dependent != null) {
                if (dependent.value().indexOf(44) == -1) {
                    writer.print("!supported_extensions.contains(\"" + dependent.value() + "\") || ");
                } else {
                    writer.print("!(false");
                    for (String extension : dependent.value().split(",")) {
                        writer.print(" || supported_extensions.contains(\"" + extension + "\")");
                    }
                    writer.print(") || ");
                }
            }
            if (dependent != null) {
                writer.print('(');
            }
            writer.print(Utils.getFunctionAddressName(d, method) + " = ");
            PlatformDependent platform_dependent = method.getAnnotation(PlatformDependent.class);
            if (platform_dependent != null) {
                EnumSet<Platform> platform_set = EnumSet.copyOf(Arrays.asList(platform_dependent.value()));
                writer.print("GLContext.getPlatformSpecificFunctionAddress(\"");
                writer.print(Platform.ALL.getPrefix() + "\", ");
                writer.print("new String[]{");
                Iterator platforms = platform_set.iterator();
                while (platforms.hasNext()) {
                    writer.print("\"" + ((Platform)((Object)platforms.next())).getOSPrefix() + "\"");
                    if (!platforms.hasNext()) continue;
                    writer.print(", ");
                }
                writer.print("}, new String[]{");
                platforms = platform_set.iterator();
                while (platforms.hasNext()) {
                    writer.print("\"" + ((Platform)((Object)platforms.next())).getPrefix() + "\"");
                    if (!platforms.hasNext()) continue;
                    writer.print(", ");
                }
                writer.print("}, ");
            } else if (aliased) {
                writer.print("GLContext.getFunctionAddress(new String[] {\"" + method.getSimpleName() + "\",\"" + method.getSimpleName() + alias_annotation.postfix() + "\"})) != 0");
            } else {
                writer.print("GLContext.getFunctionAddress(");
            }
            if (!aliased) {
                writer.print("\"" + method.getSimpleName() + "\")) != 0");
            }
            if (dependent != null) {
                writer.print(')');
            }
            if (!optional) continue;
            writer.print(" || true)");
        }
        writer.println(";");
        writer.println("\t}");
        writer.println();
    }

    public static void generateSymbolAddresses(ProcessingEnvironment env, PrintWriter writer, TypeElement d) {
        boolean first = true;
        for (ExecutableElement method : Utils.getMethods(d)) {
            if (method.getAnnotation(Alternate.class) != null || method.getAnnotation(Reuse.class) != null) continue;
            if (first) {
                writer.println("\t// " + d.getSimpleName());
                first = false;
            }
            writer.println("\tint " + Utils.getFunctionAddressName(d, method) + ";");
        }
    }

    public static void generateField(PrintWriter writer, TypeElement d) {
        writer.println("\tpublic final boolean " + GLESCapabilitiesGenerator.translateFieldName(d.getSimpleName().toString()) + ";");
    }
}

