/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator.opengl;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.lwjgl.util.generator.Alias;
import org.lwjgl.util.generator.Alternate;
import org.lwjgl.util.generator.Dependent;
import org.lwjgl.util.generator.DeprecatedGL;
import org.lwjgl.util.generator.ForceInit;
import org.lwjgl.util.generator.Optional;
import org.lwjgl.util.generator.Platform;
import org.lwjgl.util.generator.PlatformDependent;
import org.lwjgl.util.generator.Reuse;
import org.lwjgl.util.generator.Utils;

public class GLCapabilitiesGenerator {
    private static final String STUBS_LOADED_NAME = "loaded_stubs";
    private static final String ALL_INIT_METHOD_NAME = "initAllStubs";
    private static final String POINTER_INITIALIZER_POSTFIX = "_initNativeFunctionAddresses";
    private static final String CACHED_EXTS_VAR_NAME = "supported_extensions";
    private static final String PROFILE_MASK_VAR_NAME = "profileMask";
    private static final String EXTENSION_PREFIX = "GL_";
    private static final String CORE_PREFIX = "Open";

    public static void generateClassPrologue(PrintWriter writer, boolean context_specific, boolean generate_error_checks) {
        writer.println("public class ContextCapabilities {");
        writer.println("\tstatic final boolean DEBUG = " + Boolean.toString(generate_error_checks) + ";");
        writer.println("\tfinal APIUtil util = new APIUtil();");
        writer.println("\tfinal StateTracker tracker = new StateTracker();");
        writer.println();
        if (!context_specific) {
            writer.println("\tprivate static boolean loaded_stubs = false;");
        }
    }

    public static void generateInitializerPrologue(PrintWriter writer) {
        writer.println("\tContextCapabilities(boolean forwardCompatible) throws LWJGLException {");
        writer.println("\t\tSet<String> supported_extensions = initAllStubs(forwardCompatible);");
    }

    private static String translateFieldName(String interface_name) {
        if (interface_name.startsWith("GL")) {
            return CORE_PREFIX + interface_name;
        }
        return EXTENSION_PREFIX + interface_name;
    }

    public static void generateSuperClassAdds(PrintWriter writer, TypeElement d, ProcessingEnvironment env) {
        List<? extends TypeMirror> super_interfaces = d.getInterfaces();
        if (super_interfaces.size() > 1) {
            throw new RuntimeException(d + " extends more than one other interface");
        }
        if (super_interfaces.size() == 1) {
            TypeMirror super_interface = super_interfaces.iterator().next();
            writer.print("\t\tif (supported_extensions.contains(\"");
            writer.println(GLCapabilitiesGenerator.translateFieldName(d.getSimpleName().toString()) + "\"))");
            writer.print("\t\t\t");
            GLCapabilitiesGenerator.generateAddExtension(writer, env.getElementUtils().getTypeElement(super_interface.toString()));
        }
    }

    public static void generateInitializer(PrintWriter writer, TypeElement d, ProcessingEnvironment env) {
        Alias alias_annotation;
        String translated_field_name = GLCapabilitiesGenerator.translateFieldName(d.getSimpleName().toString());
        writer.print("\t\tthis." + translated_field_name + " = ");
        writer.print("supported_extensions.contains(\"");
        writer.print(translated_field_name + "\")");
        List<? extends TypeMirror> super_interfaces = d.getInterfaces();
        if (super_interfaces.size() > 1) {
            throw new RuntimeException(d + " extends more than one other interface");
        }
        if (super_interfaces.size() == 1) {
            TypeMirror super_interface = super_interfaces.iterator().next();
            writer.println();
            writer.print("\t\t\t&& supported_extensions.contains(\"");
            writer.print(GLCapabilitiesGenerator.translateFieldName(env.getElementUtils().getTypeElement(super_interface.toString()).getSimpleName().toString()) + "\")");
        }
        if ((alias_annotation = d.getAnnotation(Alias.class)) != null) {
            writer.println();
            writer.print("\t\t\t|| supported_extensions.contains(\"");
            writer.print(GLCapabilitiesGenerator.translateFieldName(alias_annotation.value()) + "\")");
        }
        writer.println(";");
    }

    private static String getAddressesInitializerName(String class_name) {
        return class_name + POINTER_INITIALIZER_POSTFIX;
    }

    public static void generateInitStubsPrologue(PrintWriter writer, boolean context_specific) {
        writer.println("\tprivate Set<String> initAllStubs(boolean forwardCompatible) throws LWJGLException {");
        writer.println("\t\tglGetError = GLContext.getFunctionAddress(\"glGetError\");");
        writer.println("\t\tglGetString = GLContext.getFunctionAddress(\"glGetString\");");
        writer.println("\t\tglGetIntegerv = GLContext.getFunctionAddress(\"glGetIntegerv\");");
        writer.println("\t\tglGetStringi = GLContext.getFunctionAddress(\"glGetStringi\");");
        writer.println("\t\tGLContext.setCapabilities(this);");
        writer.println("\t\tSet<String> supported_extensions = new HashSet<String>(256);");
        writer.println("\t\tint profileMask = GLContext.getSupportedExtensions(supported_extensions);");
        writer.println("\t\tif ( supported_extensions.contains(\"OpenGL31\") && !(supported_extensions.contains(\"GL_ARB_compatibility\") || (profileMask & GL32.GL_CONTEXT_COMPATIBILITY_PROFILE_BIT) != 0) )");
        writer.println("\t\t\tforwardCompatible = true;");
        if (!context_specific) {
            writer.println("\t\tif (loaded_stubs)");
            writer.println("\t\t\treturn GLContext.getSupportedExtensions();");
            writer.println("\t\torg.lwjgl.opengl.GL11.initNativeStubs();");
        } else {
            writer.println("\t\tif (!" + GLCapabilitiesGenerator.getAddressesInitializerName("GL11") + "(forwardCompatible))");
            writer.println("\t\t\tthrow new LWJGLException(\"GL11 not supported\");");
        }
    }

    public static void generateInitStubsEpilogue(PrintWriter writer, boolean context_specific) {
        if (!context_specific) {
            writer.println("\t\tloaded_stubs = true;");
        }
        writer.println("\t\treturn supported_extensions;");
        writer.println("\t}");
    }

    public static void generateUnloadStubs(ProcessingEnvironment env, PrintWriter writer, TypeElement d) {
        if (Utils.getMethods(d).size() > 0) {
            writer.print("\t\tGLContext.resetNativeStubs(" + Utils.getSimpleClassName(d));
            writer.println(".class);");
        }
    }

    public static void generateInitStubs(ProcessingEnvironment env, PrintWriter writer, TypeElement d, boolean context_specific) {
        if (Utils.getMethods(d).size() > 0) {
            if (context_specific) {
                Alias alias_annotation = d.getAnnotation(Alias.class);
                if (d.getAnnotation(ForceInit.class) != null) {
                    writer.println("\t\tsupported_extensions.add(\"" + GLCapabilitiesGenerator.translateFieldName(d.getSimpleName().toString()) + "\");");
                }
                writer.print("\t\tif (");
                if (alias_annotation != null) {
                    writer.print("(");
                }
                writer.print("supported_extensions.contains(\"");
                writer.print(GLCapabilitiesGenerator.translateFieldName(d.getSimpleName().toString()) + "\")");
                if (alias_annotation != null) {
                    writer.print(" || supported_extensions.contains(\"");
                    writer.print(GLCapabilitiesGenerator.translateFieldName(alias_annotation.value()) + "\"))");
                }
                writer.print(" && !" + GLCapabilitiesGenerator.getAddressesInitializerName(d.getSimpleName().toString()) + "(");
                if (d.getAnnotation(DeprecatedGL.class) != null) {
                    writer.print("forwardCompatible");
                }
                if (d.getAnnotation(Dependent.class) != null) {
                    if (d.getAnnotation(DeprecatedGL.class) != null) {
                        writer.print(",");
                    }
                    writer.print(CACHED_EXTS_VAR_NAME);
                }
                if (alias_annotation != null) {
                    writer.println(")) {");
                    writer.print("\t\t\tremove(supported_extensions, \"");
                    writer.println(GLCapabilitiesGenerator.translateFieldName(alias_annotation.value()) + "\");");
                } else {
                    writer.println("))");
                }
                writer.print("\t\t\tremove(supported_extensions, \"");
                writer.println(GLCapabilitiesGenerator.translateFieldName(d.getSimpleName().toString()) + "\");");
                if (alias_annotation != null) {
                    writer.println("\t\t}");
                }
            } else {
                writer.print("\t\tGLContext.initNativeStubs(" + Utils.getSimpleClassName(d));
                writer.println(".class, supported_extensions, \"" + GLCapabilitiesGenerator.translateFieldName(d.getSimpleName().toString()) + "\");");
            }
        }
    }

    private static void generateAddExtension(PrintWriter writer, TypeElement d) {
        writer.print("supported_extensions.add(\"");
        writer.println(GLCapabilitiesGenerator.translateFieldName(d.getSimpleName().toString()) + "\");");
    }

    public static void generateAddressesInitializers(ProcessingEnvironment env, PrintWriter writer, TypeElement d) {
        Alias alias_annotation;
        Iterator<ExecutableElement> methods = Utils.getMethods(d).iterator();
        if (!methods.hasNext()) {
            return;
        }
        writer.print("\tprivate boolean " + GLCapabilitiesGenerator.getAddressesInitializerName(d.getSimpleName().toString()) + "(");
        boolean deprecated = d.getAnnotation(DeprecatedGL.class) != null;
        Dependent dependent = d.getAnnotation(Dependent.class);
        if (deprecated) {
            writer.print("boolean forwardCompatible");
        }
        if (dependent != null) {
            if (deprecated) {
                writer.print(",");
            }
            writer.print("Set<String> supported_extensions");
        }
        boolean aliased = (alias_annotation = d.getAnnotation(Alias.class)) != null && alias_annotation.postfix().length() > 0;
        writer.println(") {");
        writer.println("\t\treturn ");
        boolean first = true;
        while (methods.hasNext()) {
            ExecutableElement method = methods.next();
            if (method.getAnnotation(Alternate.class) != null) continue;
            if (!first) {
                writer.println(" &");
            } else {
                first = false;
            }
            boolean optional = method.getAnnotation(Optional.class) != null;
            deprecated = method.getAnnotation(DeprecatedGL.class) != null;
            dependent = method.getAnnotation(Dependent.class);
            writer.print("\t\t\t(");
            if (optional) {
                writer.print('(');
            }
            if (deprecated) {
                writer.print("forwardCompatible || ");
            }
            if (dependent != null) {
                if (dependent.value().indexOf(44) == -1) {
                    writer.print("!supported_extensions.contains(\"" + dependent.value() + "\") || ");
                } else {
                    writer.print("!(false");
                    for (String extension : dependent.value().split(",")) {
                        writer.print(" || supported_extensions.contains(\"" + extension + "\")");
                    }
                    writer.print(") || ");
                }
            }
            if (deprecated || dependent != null) {
                writer.print('(');
            }
            writer.print(Utils.getFunctionAddressName(d, method) + " = ");
            PlatformDependent platform_dependent = method.getAnnotation(PlatformDependent.class);
            if (platform_dependent != null) {
                EnumSet<Platform> platform_set = EnumSet.copyOf(Arrays.asList(platform_dependent.value()));
                writer.print("GLContext.getPlatformSpecificFunctionAddress(\"");
                writer.print(Platform.ALL.getPrefix() + "\", ");
                writer.print("new String[]{");
                Iterator platforms = platform_set.iterator();
                while (platforms.hasNext()) {
                    writer.print("\"" + ((Platform)((Object)platforms.next())).getOSPrefix() + "\"");
                    if (!platforms.hasNext()) continue;
                    writer.print(", ");
                }
                writer.print("}, new String[]{");
                platforms = platform_set.iterator();
                while (platforms.hasNext()) {
                    writer.print("\"" + ((Platform)((Object)platforms.next())).getPrefix() + "\"");
                    if (!platforms.hasNext()) continue;
                    writer.print(", ");
                }
                writer.print("}, ");
            } else if (aliased) {
                writer.print("GLContext.getFunctionAddress(new String[] {\"" + method.getSimpleName() + "\",\"" + method.getSimpleName() + alias_annotation.postfix() + "\"})) != 0");
            } else {
                writer.print("GLContext.getFunctionAddress(");
            }
            if (!aliased) {
                writer.print("\"" + method.getSimpleName() + "\")) != 0");
            }
            if (deprecated || dependent != null) {
                writer.print(')');
            }
            if (!optional) continue;
            writer.print(" || true)");
        }
        writer.println(";");
        writer.println("\t}");
        writer.println();
    }

    public static void generateSymbolAddresses(ProcessingEnvironment env, PrintWriter writer, TypeElement d) {
        boolean first = true;
        for (ExecutableElement method : Utils.getMethods(d)) {
            if (method.getAnnotation(Alternate.class) != null || method.getAnnotation(Reuse.class) != null) continue;
            if (first) {
                writer.println("\t// " + d.getSimpleName());
                first = false;
            }
            writer.println("\tlong " + Utils.getFunctionAddressName(d, method) + ";");
        }
    }

    public static void generateField(PrintWriter writer, TypeElement d) {
        writer.println("\tpublic final boolean " + GLCapabilitiesGenerator.translateFieldName(d.getSimpleName().toString()) + ";");
    }
}

