/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator.opencl;

import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import org.lwjgl.PointerWrapper;
import org.lwjgl.util.generator.Extension;
import org.lwjgl.util.generator.Private;
import org.lwjgl.util.generator.Utils;
import org.lwjgl.util.generator.opencl.CLGeneratorProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLPDCapabilitiesGenerator {
    private static final int[][] CL_VERSIONS = new int[][]{{1, 2}};

    static void generateClassPrologue(PrintWriter writer, String name) {
        writer.println("public class " + name + " {");
        writer.println();
        writer.println("\tpublic final int majorVersion;");
        writer.println("\tpublic final int minorVersion;");
        writer.println();
        for (int major = 1; major <= CL_VERSIONS.length; ++major) {
            for (int minor : CL_VERSIONS[major - 1]) {
                writer.println("\tpublic final boolean OpenCL" + Integer.toString(major) + Integer.toString(minor) + ";");
            }
        }
        writer.println();
    }

    static void generateExtensions(PrintWriter writer, TypeElement d) {
        writer.print("\t");
        if (d.getAnnotation(Private.class) == null) {
            writer.print("public ");
        }
        writer.println("final boolean " + CLGeneratorProcessor.getExtensionName(d.getSimpleName().toString()) + ";");
    }

    static void generateConstructor(ProcessingEnvironment env, PrintWriter writer, Set<? extends TypeElement> templates, Class<? extends Annotation> capsType, String capsName, Class<? extends PointerWrapper> objectType, String objectName) {
        writer.println("\tpublic " + capsName + "(final " + objectType.getSimpleName() + ' ' + objectName + ") {");
        writer.println("\t\tfinal String extensionList = " + objectName + ".getInfoString(CL10.CL_" + objectName.toUpperCase() + "_EXTENSIONS);\n\t\tfinal String version = " + objectName + ".getInfoString(CL10.CL_" + objectName.toUpperCase() + "_VERSION);\n\t\tif ( !version.startsWith(\"OpenCL \") )\n\t\t\tthrow new RuntimeException(\"Invalid OpenCL version string: \" + version);\n\n\t\ttry {\n\t\t\tfinal StringTokenizer tokenizer = new StringTokenizer(version.substring(7), \". \");\n\n\t\t\tmajorVersion = Integer.parseInt(tokenizer.nextToken());\n\t\t\tminorVersion = Integer.parseInt(tokenizer.nextToken());\n");
        for (int major = 1; major <= CL_VERSIONS.length; ++major) {
            for (int minor : CL_VERSIONS[major - 1]) {
                writer.println("\t\t\tOpenCL" + Integer.toString(major) + Integer.toString(minor) + " = " + major + " < majorVersion || (" + major + " == majorVersion && " + minor + " <= minorVersion);");
            }
        }
        writer.println("\t\t} catch (RuntimeException e) {\n\t\t\tthrow new RuntimeException(\"The major and/or minor OpenCL version \\\"\" + version + \"\\\" is malformed: \" + e.getMessage());\n\t\t}\n");
        writer.println("\t\tfinal Set<String> extensions = APIUtil.getExtensions(extensionList);");
        for (TypeElement typeElement : templates) {
            if (typeElement.getAnnotation(capsType) == null) continue;
            String extName = CLGeneratorProcessor.getExtensionName(typeElement.getSimpleName().toString());
            String nativeName = extName.toLowerCase();
            Extension ext = typeElement.getAnnotation(Extension.class);
            if (ext != null && !ext.nativeName().isEmpty()) {
                nativeName = ext.nativeName();
            }
            writer.print("\t\t" + extName + " = extensions.contains(\"" + nativeName + "\")");
            if (!Utils.getMethods(typeElement).isEmpty()) {
                writer.print(" && CLCapabilities." + extName);
            }
            writer.println(";");
        }
        writer.println("\t}\n");
    }

    public static void generateGetters(PrintWriter writer) {
        writer.println("\tpublic int getMajorVersion() {");
        writer.println("\t\treturn majorVersion;");
        writer.println("\t}\n");
        writer.println("\tpublic int getMinorVersion() {");
        writer.println("\t\treturn minorVersion;");
        writer.println("\t}\n");
    }

    public static void generateToString(PrintWriter writer, Set<? extends TypeElement> templates, Class<? extends Annotation> capsType) {
        writer.println("\tpublic String toString() {");
        writer.println("\t\tfinal StringBuilder buf = new StringBuilder();\n");
        writer.println("\t\tbuf.append(\"OpenCL \").append(majorVersion).append('.').append(minorVersion);");
        writer.println();
        writer.println("\t\tbuf.append(\" - Extensions: \");");
        for (TypeElement typeElement : templates) {
            if (typeElement.getAnnotation(capsType) == null) continue;
            writer.println("\t\tif ( " + CLGeneratorProcessor.getExtensionName(typeElement.getSimpleName().toString()) + " ) buf.append(\"" + CLGeneratorProcessor.getExtensionName(typeElement.getSimpleName().toString()).toLowerCase() + " \");");
        }
        writer.println("\n\t\treturn buf.toString();");
        writer.println("\t}\n");
    }
}

