/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator.opencl;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.lwjgl.PointerWrapper;
import org.lwjgl.opencl.CLDevice;
import org.lwjgl.opencl.CLPlatform;
import org.lwjgl.util.generator.opencl.CLCapabilitiesGenerator;
import org.lwjgl.util.generator.opencl.CLDeviceExtension;
import org.lwjgl.util.generator.opencl.CLPDCapabilitiesGenerator;
import org.lwjgl.util.generator.opencl.CLPlatformExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_5)
@SupportedOptions(value={"generatechecks", "contextspecific"})
public class CLGeneratorProcessor
extends AbstractProcessor {
    public static final String CLCAPS_CLASS_NAME = "CLCapabilities";
    public static final String PLATFORM_CAPS_CLASS_NAME = "CLPlatformCapabilities";
    public static final String DEVICE_CAPS_CLASS_NAME = "CLDeviceCapabilities";
    private static final String EXTENSION_PREFIX = "CL_";
    private static final String CORE_PREFIX = "Open";
    private static boolean first_round = true;

    static String getExtensionName(String interface_name) {
        if (interface_name.startsWith("CL")) {
            return CORE_PREFIX + interface_name;
        }
        return EXTENSION_PREFIX + interface_name;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver() || !first_round) {
            System.exit(0);
            return true;
        }
        try {
            Set<TypeElement> templates = ElementFilter.typesIn(roundEnv.getRootElements());
            this.generateCLCapabilitiesSource(templates);
            this.generateCLPDCapabilitiesSource(templates, CLPlatformExtension.class, PLATFORM_CAPS_CLASS_NAME, CLPlatform.class, "platform");
            this.generateCLPDCapabilitiesSource(templates, CLDeviceExtension.class, DEVICE_CAPS_CLASS_NAME, CLDevice.class, "device");
            first_round = false;
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void printHeader(PrintWriter writer) {
        writer.println("/* MACHINE GENERATED FILE, DO NOT EDIT */");
        writer.println();
        writer.println("package org.lwjgl.opencl;");
        writer.println();
    }

    private void generateCLCapabilitiesSource(Set<TypeElement> templates) throws IOException {
        PrintWriter writer = new PrintWriter(this.processingEnv.getFiler().createSourceFile("org.lwjgl.opencl.CLCapabilities", this.processingEnv.getElementUtils().getPackageElement("org.lwjgl.opencl")).openWriter());
        CLGeneratorProcessor.printHeader(writer);
        CLCapabilitiesGenerator.generateClassPrologue(writer);
        for (TypeElement d : templates) {
            if (!d.getKind().isInterface()) continue;
            CLCapabilitiesGenerator.generateSymbolAddresses(this.processingEnv, writer, d);
        }
        writer.println();
        CLCapabilitiesGenerator.generateConstructor(this.processingEnv, writer, templates);
        CLCapabilitiesGenerator.generateCapabilitiesGetters(writer);
        for (TypeElement d : templates) {
            if (!d.getKind().isInterface()) continue;
            CLCapabilitiesGenerator.generateExtensionChecks(this.processingEnv, writer, d);
        }
        writer.println("}");
        writer.close();
    }

    private void generateCLPDCapabilitiesSource(Set<TypeElement> templates, Class<? extends Annotation> capsType, String capsName, Class<? extends PointerWrapper> objectType, String objectName) throws IOException {
        PrintWriter writer = new PrintWriter(this.processingEnv.getFiler().createSourceFile("org.lwjgl.opencl." + capsName, this.processingEnv.getElementUtils().getPackageElement("org.lwjgl.opencl")).openWriter());
        CLGeneratorProcessor.printHeader(writer);
        writer.println("import java.util.*;");
        writer.println();
        CLPDCapabilitiesGenerator.generateClassPrologue(writer, capsName);
        for (TypeElement t : templates) {
            if (!t.getKind().isInterface() || t.getAnnotation(capsType) == null) continue;
            CLPDCapabilitiesGenerator.generateExtensions(writer, t);
        }
        writer.println();
        CLPDCapabilitiesGenerator.generateConstructor(this.processingEnv, writer, templates, capsType, capsName, objectType, objectName);
        CLPDCapabilitiesGenerator.generateGetters(writer);
        CLPDCapabilitiesGenerator.generateToString(writer, templates, capsType);
        writer.println("}");
        writer.close();
    }
}

