/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator.opencl;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.lwjgl.util.generator.Alias;
import org.lwjgl.util.generator.Alternate;
import org.lwjgl.util.generator.Optional;
import org.lwjgl.util.generator.Reuse;
import org.lwjgl.util.generator.Utils;
import org.lwjgl.util.generator.opencl.CLDeviceExtension;
import org.lwjgl.util.generator.opencl.CLGeneratorProcessor;
import org.lwjgl.util.generator.opencl.CLPlatformExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLCapabilitiesGenerator {
    static void generateClassPrologue(PrintWriter writer) {
        writer.println("public final class CLCapabilities {");
        writer.println();
    }

    static void generateSymbolAddresses(ProcessingEnvironment env, PrintWriter writer, TypeElement d) {
        if (d.getAnnotation(CLPlatformExtension.class) == null && d.getAnnotation(CLDeviceExtension.class) == null && !d.getSimpleName().toString().startsWith("CL")) {
            throw new RuntimeException("An OpenCL extension is missing an extension type annotation: " + d.getSimpleName());
        }
        Alias alias_annotation = d.getAnnotation(Alias.class);
        boolean aliased = alias_annotation != null && alias_annotation.postfix().length() > 0;
        boolean foundNative = false;
        for (ExecutableElement method : Utils.getMethods(d)) {
            if (method.getAnnotation(Alternate.class) != null || method.getAnnotation(Reuse.class) != null) continue;
            if (!foundNative) {
                writer.println("\tstatic final boolean " + CLGeneratorProcessor.getExtensionName(d.getSimpleName().toString() + ";"));
                foundNative = true;
            }
            writer.print("\tstatic final long " + Utils.getFunctionAddressName(d, method) + " = CL.getFunctionAddress(");
            if (aliased) {
                writer.println("new String [] {\"" + Utils.getFunctionAddressName(d, method) + "\",\"" + method.getSimpleName() + alias_annotation.postfix() + "\"});");
                continue;
            }
            writer.println("\"" + Utils.getFunctionAddressName(d, method) + "\");");
        }
        if (foundNative) {
            writer.println();
        }
    }

    static void generateConstructor(ProcessingEnvironment env, PrintWriter writer, Set<? extends TypeElement> interface_decls) {
        writer.println("\tprivate CLCapabilities() {}");
        writer.println();
        writer.println("\tstatic {");
        for (TypeElement typeElement : interface_decls) {
            if (!typeElement.getKind().isInterface() || Utils.getMethods(typeElement).isEmpty()) continue;
            writer.println("\t\t" + CLGeneratorProcessor.getExtensionName(typeElement.getSimpleName().toString()) + " = " + CLCapabilitiesGenerator.getExtensionSupportedName(typeElement.getSimpleName().toString()) + "();");
        }
        writer.println("\t}\n");
    }

    static void generateExtensionChecks(ProcessingEnvironment env, PrintWriter writer, TypeElement d) {
        Iterator<ExecutableElement> methods = Utils.getMethods(d).iterator();
        if (!methods.hasNext()) {
            return;
        }
        writer.println("\tprivate static boolean " + CLCapabilitiesGenerator.getExtensionSupportedName(d.getSimpleName().toString()) + "() {");
        writer.println("\t\treturn ");
        boolean first = true;
        while (methods.hasNext()) {
            ExecutableElement method = methods.next();
            if (method.getAnnotation(Alternate.class) != null) continue;
            if (!first) {
                writer.println(" &");
            } else {
                first = false;
            }
            boolean optional = method.getAnnotation(Optional.class) != null;
            writer.print("\t\t\t");
            if (optional) {
                writer.print('(');
            }
            writer.print(Utils.getFunctionAddressName(d, method) + " != 0");
            if (!optional) continue;
            writer.print(" || true)");
        }
        writer.println(";");
        writer.println("\t}");
        writer.println();
    }

    private static String getExtensionSupportedName(String class_name) {
        return "is" + class_name + "Supported";
    }

    public static void generateCapabilitiesGetters(PrintWriter writer) {
        writer.println("\tpublic static CLPlatformCapabilities getPlatformCapabilities(final CLPlatform platform) {\n\t\tplatform.checkValid();\n\n\t\tCLPlatformCapabilities caps = (CLPlatformCapabilities)platform.getCapabilities();\n\t\tif ( caps == null )\n\t\t\tplatform.setCapabilities(caps = new CLPlatformCapabilities(platform));\n\n\t\treturn caps;\n\t}\n");
        writer.println("\tpublic static CLDeviceCapabilities getDeviceCapabilities(final CLDevice device) {\n\t\tdevice.checkValid();\n\n\t\tCLDeviceCapabilities caps = (CLDeviceCapabilities)device.getCapabilities();\n\t\tif ( caps == null )\n\t\t\tdevice.setCapabilities(caps = new CLDeviceCapabilities(device));\n\n\t\treturn caps;\n\t}\n");
    }
}

