/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import java.lang.annotation.Annotation;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.lwjgl.PointerBuffer;
import org.lwjgl.PointerWrapper;
import org.lwjgl.util.generator.NativeTypeTranslator;
import org.lwjgl.util.generator.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SignatureTranslator
extends SimpleTypeVisitor6<Void, Void> {
    private final StringBuilder signature = new StringBuilder();
    private static final Pattern DOT_PATTERN = Pattern.compile("\\.");

    SignatureTranslator() {
    }

    private static String getNativeNameFromClassName(String class_name) {
        return DOT_PATTERN.matcher(class_name).replaceAll("/");
    }

    public String getSignature() {
        return this.signature.toString();
    }

    @Override
    public Void visitArray(ArrayType t, Void o) {
        Class type = Utils.getJavaType(t.getComponentType());
        if (CharSequence.class.isAssignableFrom(type)) {
            this.signature.append("J");
        } else if (Buffer.class.isAssignableFrom(type)) {
            this.signature.append("[Ljava/nio/ByteBuffer;");
        } else if (PointerWrapper.class.isAssignableFrom(type)) {
            this.signature.append("[L" + SignatureTranslator.getNativeNameFromClassName(type.getName()) + ";");
        } else {
            throw new RuntimeException(t + " is not allowed");
        }
        return (Void)this.DEFAULT_VALUE;
    }

    private void visitClassType(DeclaredType t) {
        Class<? extends Annotation> type = NativeTypeTranslator.getClassFromType(t);
        if (PointerWrapper.class.isAssignableFrom(type) || Utils.isAddressableType(type) && !String.class.equals(type)) {
            this.signature.append("J");
        } else {
            String type_name = CharSequence.class.isAssignableFrom(type) && !String.class.equals(type) || CharSequence[].class.isAssignableFrom(type) || PointerBuffer.class.isAssignableFrom(type) ? ByteBuffer.class.getName() : t.toString();
            this.signature.append("L");
            this.signature.append(SignatureTranslator.getNativeNameFromClassName(type_name));
            this.signature.append(";");
        }
    }

    @Override
    public Void visitDeclared(DeclaredType t, Void o) {
        if (t.asElement().getKind().isClass()) {
            this.visitClassType(t);
        } else if (t.asElement().getKind().isInterface()) {
            this.visitInterfaceType(t);
        }
        return (Void)this.DEFAULT_VALUE;
    }

    private void visitInterfaceType(DeclaredType t) {
        Class<? extends Annotation> type = NativeTypeTranslator.getClassFromType(t);
        if (!PointerWrapper.class.isAssignableFrom(type)) {
            throw new RuntimeException(t + " is not allowed");
        }
        this.signature.append("J");
    }

    @Override
    public Void visitPrimitive(PrimitiveType t, Void o) {
        switch (t.getKind()) {
            case BOOLEAN: {
                this.signature.append("Z");
                break;
            }
            case INT: {
                this.signature.append("I");
                break;
            }
            case FLOAT: {
                this.signature.append("F");
                break;
            }
            case SHORT: {
                this.signature.append("S");
                break;
            }
            case DOUBLE: {
                this.signature.append("D");
                break;
            }
            case BYTE: {
                this.signature.append("B");
                break;
            }
            case LONG: {
                this.signature.append("J");
                break;
            }
            default: {
                throw new RuntimeException("Unsupported type " + t);
            }
        }
        return (Void)this.DEFAULT_VALUE;
    }

    @Override
    public Void visitNoType(NoType t, Void o) {
        this.signature.append("V");
        return (Void)this.DEFAULT_VALUE;
    }
}

