/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.lwjgl.util.generator.Alternate;
import org.lwjgl.util.generator.AutoSize;
import org.lwjgl.util.generator.BufferObject;
import org.lwjgl.util.generator.CachedResult;
import org.lwjgl.util.generator.Constant;
import org.lwjgl.util.generator.Helper;
import org.lwjgl.util.generator.Mode;
import org.lwjgl.util.generator.Optional;
import org.lwjgl.util.generator.Platform;
import org.lwjgl.util.generator.PlatformDependent;
import org.lwjgl.util.generator.Result;
import org.lwjgl.util.generator.Reuse;
import org.lwjgl.util.generator.SignatureTranslator;
import org.lwjgl.util.generator.Utils;

public class RegisterStubsGenerator {
    private static final Pattern GL_PATTERN = Pattern.compile("gl");

    public static void generateMethodsNativeStubBind(PrintWriter writer, TypeElement d, boolean generate_error_checks, boolean context_specific) {
        Iterator<ExecutableElement> it = Utils.getMethods(d).iterator();
        while (it.hasNext()) {
            ExecutableElement method = it.next();
            Alternate alt_annotation = method.getAnnotation(Alternate.class);
            if (alt_annotation != null && (!alt_annotation.nativeAlt() || alt_annotation.skipNative()) || method.getAnnotation(Reuse.class) != null) continue;
            PlatformDependent platform_annotation = method.getAnnotation(PlatformDependent.class);
            EnumSet<Platform> platforms = platform_annotation != null ? EnumSet.copyOf(Arrays.asList(platform_annotation.value())) : EnumSet.of(Platform.ALL);
            for (Platform platform : platforms) {
                platform.printPrologue(writer);
                boolean has_buffer_parameter = Utils.hasMethodBufferObjectParameter(method);
                RegisterStubsGenerator.printMethodNativeStubBind(writer, d, method, platform, Mode.NORMAL, it.hasNext() || has_buffer_parameter, generate_error_checks, context_specific);
                if (has_buffer_parameter) {
                    RegisterStubsGenerator.printMethodNativeStubBind(writer, d, method, platform, Mode.BUFFEROBJECT, it.hasNext(), generate_error_checks, context_specific);
                }
                platform.printEpilogue(writer);
            }
        }
        writer.println();
    }

    private static String getTypeSignature(TypeMirror type) {
        SignatureTranslator v = new SignatureTranslator();
        type.accept(v, null);
        return v.getSignature();
    }

    private static String getMethodSignature(ExecutableElement method, Mode mode) {
        String result_type_signature;
        boolean isNIOBuffer;
        List<? extends VariableElement> params = method.getParameters();
        String signature = "(";
        for (VariableElement variableElement : params) {
            Constant constant_annotation;
            if (variableElement.getAnnotation(Result.class) != null || variableElement.getAnnotation(Helper.class) != null && !variableElement.getAnnotation(Helper.class).passToNative() || (constant_annotation = variableElement.getAnnotation(Constant.class)) != null && constant_annotation.isNative()) continue;
            if (mode == Mode.BUFFEROBJECT && variableElement.getAnnotation(BufferObject.class) != null) {
                signature = signature + "J";
                continue;
            }
            signature = signature + RegisterStubsGenerator.getTypeSignature(variableElement.asType());
        }
        TypeMirror result_type = Utils.getMethodReturnType(method);
        CachedResult cachedResult = method.getAnnotation(CachedResult.class);
        AutoSize auto_size_annotation = method.getAnnotation(AutoSize.class);
        boolean bl = isNIOBuffer = Utils.getNIOBufferType(result_type) != null;
        if (isNIOBuffer && (auto_size_annotation == null || !auto_size_annotation.isNative())) {
            signature = signature + "J";
        }
        String string = result_type_signature = isNIOBuffer ? "Ljava/nio/ByteBuffer;" : RegisterStubsGenerator.getTypeSignature(result_type);
        if (cachedResult != null) {
            signature = signature + result_type_signature;
        }
        signature = signature + ")";
        signature = signature + result_type_signature;
        return signature;
    }

    private static void printMethodNativeStubBind(PrintWriter writer, TypeElement d, ExecutableElement method, Platform platform, Mode mode, boolean has_more, boolean generate_error_checks, boolean context_specific) {
        Alternate alt_annotation;
        writer.print("\t\t{\"" + Utils.getSimpleNativeMethodName(method, generate_error_checks, context_specific));
        if (mode == Mode.BUFFEROBJECT) {
            writer.print("BO");
        }
        writer.print("\", \"" + RegisterStubsGenerator.getMethodSignature(method, mode) + "\", (void *)&");
        writer.print(Utils.getQualifiedNativeMethodName(Utils.getQualifiedClassName(d), method, generate_error_checks, context_specific));
        if (mode == Mode.BUFFEROBJECT) {
            writer.print("BO");
        }
        String methodName = (alt_annotation = method.getAnnotation(Alternate.class)) == null ? method.getSimpleName().toString() : alt_annotation.value();
        String opengl_handle_name = GL_PATTERN.matcher(methodName).replaceFirst(platform.getPrefix());
        writer.print(", \"" + opengl_handle_name + "\", (void *)&" + methodName + ", " + (method.getAnnotation(Optional.class) == null ? "false" : "true") + "}");
        if (has_more) {
            writer.println(",");
        }
    }
}

