/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import java.lang.annotation.Annotation;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.lwjgl.PointerBuffer;
import org.lwjgl.util.generator.Const;
import org.lwjgl.util.generator.NativeType;
import org.lwjgl.util.generator.PointerWrapper;
import org.lwjgl.util.generator.TypeMap;
import org.lwjgl.util.generator.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeTypeTranslator
extends SimpleTypeVisitor6<Void, Void> {
    private Collection<Class> native_types;
    private boolean is_indirect;
    private final Element declaration;
    private final TypeMap type_map;

    public NativeTypeTranslator(TypeMap type_map, Element declaration) {
        this.declaration = declaration;
        this.type_map = type_map;
    }

    public String getSignature() {
        return this.getSignature(false);
    }

    public String getSignature(boolean skipConst) {
        StringBuilder signature = new StringBuilder();
        if (!skipConst && this.declaration.getAnnotation(Const.class) != null) {
            signature.append("const ");
        }
        if (this.declaration.getAnnotation(PointerWrapper.class) != null) {
            signature.append(this.declaration.getAnnotation(PointerWrapper.class).value());
        } else if (this.declaration.getAnnotation(NativeType.class) != null) {
            signature.append(this.declaration.getAnnotation(NativeType.class).value());
        } else {
            signature.append(this.getAnnotationType().getSimpleName());
        }
        if (this.is_indirect) {
            signature.append(" *");
        }
        return signature.toString();
    }

    public Class getAnnotationType() {
        if (this.native_types.size() != 1) {
            throw new RuntimeException("Expected only one native type for declaration " + this.declaration + ", but got " + this.native_types.size());
        }
        return this.native_types.iterator().next();
    }

    @Override
    public Void visitArray(ArrayType t, Void o) {
        Class<?> type = Utils.getJavaType(t).getComponentType();
        if (CharSequence.class.isAssignableFrom(type)) {
            this.is_indirect = true;
            this.native_types = new ArrayList<Class>();
            this.native_types.add(this.type_map.getStringArrayType());
        } else if (Buffer.class.isAssignableFrom(type)) {
            this.is_indirect = true;
            this.native_types = new ArrayList<Class>();
            this.native_types.add(this.type_map.getByteBufferArrayType());
        } else if (org.lwjgl.PointerWrapper.class.isAssignableFrom(type)) {
            this.is_indirect = false;
        } else {
            throw new RuntimeException(t + " is not allowed");
        }
        return (Void)this.DEFAULT_VALUE;
    }

    public static TypeKind getPrimitiveKindFromBufferClass(Class c) {
        if (IntBuffer.class.equals((Object)c)) {
            return TypeKind.INT;
        }
        if (DoubleBuffer.class.equals((Object)c)) {
            return TypeKind.DOUBLE;
        }
        if (ShortBuffer.class.equals((Object)c)) {
            return TypeKind.SHORT;
        }
        if (ByteBuffer.class.equals((Object)c) || PointerBuffer.class.equals((Object)c)) {
            return TypeKind.BYTE;
        }
        if (FloatBuffer.class.equals((Object)c)) {
            return TypeKind.FLOAT;
        }
        if (LongBuffer.class.equals((Object)c)) {
            return TypeKind.LONG;
        }
        throw new RuntimeException(c + " is not allowed");
    }

    public static Class<? extends Annotation> getClassFromType(DeclaredType t) {
        try {
            return Class.forName(t.toString());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void getNativeTypeFromAnnotatedPrimitiveType(TypeKind kind) {
        this.native_types = this.translateAnnotations();
        if (this.native_types.isEmpty()) {
            this.native_types.add(this.type_map.getNativeTypeFromPrimitiveType(kind));
        }
    }

    private void visitClassType(DeclaredType t) {
        this.is_indirect = true;
        Class<? extends Annotation> c = NativeTypeTranslator.getClassFromType(t);
        if (String.class.equals(c)) {
            this.native_types = new ArrayList<Class>();
            this.native_types.add(this.type_map.getStringElementType());
        } else if (Buffer.class.equals(c)) {
            this.native_types = new ArrayList<Class>();
            this.native_types.add(this.type_map.getVoidType());
        } else if (Buffer.class.isAssignableFrom(c) || PointerBuffer.class.isAssignableFrom(c)) {
            TypeKind kind = NativeTypeTranslator.getPrimitiveKindFromBufferClass(c);
            this.getNativeTypeFromAnnotatedPrimitiveType(kind);
        } else if (org.lwjgl.PointerWrapper.class.isAssignableFrom(c)) {
            this.native_types = new ArrayList<Class>();
            this.native_types.add(PointerWrapper.class);
            this.is_indirect = false;
        } else {
            throw new RuntimeException(t + " is not allowed");
        }
    }

    @Override
    public Void visitPrimitive(PrimitiveType t, Void p) {
        this.getNativeTypeFromAnnotatedPrimitiveType(t.getKind());
        return (Void)this.DEFAULT_VALUE;
    }

    private void visitInterfaceType(DeclaredType t) {
        Class<? extends Annotation> c = NativeTypeTranslator.getClassFromType(t);
        if (!org.lwjgl.PointerWrapper.class.isAssignableFrom(c)) {
            throw new RuntimeException(t + " is not allowed");
        }
        this.native_types = new ArrayList<Class>();
        this.native_types.add(PointerWrapper.class);
        this.is_indirect = false;
    }

    @Override
    public Void visitDeclared(DeclaredType t, Void p) {
        if (t.asElement().getKind().isInterface()) {
            this.visitInterfaceType(t);
        } else if (t.asElement().getKind().isClass()) {
            this.visitClassType(t);
        }
        return (Void)this.DEFAULT_VALUE;
    }

    public static <T extends Annotation> T getAnnotation(AnnotationMirror annotation, Class<T> type) {
        return annotation.getAnnotationType().asElement().getAnnotation(type);
    }

    private static Class translateAnnotation(AnnotationMirror annotation) {
        NativeType native_type = NativeTypeTranslator.getAnnotation(annotation, NativeType.class);
        if (native_type != null) {
            return NativeTypeTranslator.getClassFromType(annotation.getAnnotationType());
        }
        return null;
    }

    private List<Class> translateAnnotations() {
        ArrayList<Class> result = new ArrayList<Class>();
        for (AnnotationMirror annotation : Utils.getSortedAnnotations(this.declaration.getAnnotationMirrors())) {
            Class translated_result = NativeTypeTranslator.translateAnnotation(annotation);
            if (translated_result == null) continue;
            result.add(translated_result);
        }
        return result;
    }

    @Override
    public Void visitNoType(NoType t, Void p) {
        this.native_types = this.translateAnnotations();
        if (this.native_types.isEmpty()) {
            this.native_types.add(Void.TYPE);
        }
        return (Void)this.DEFAULT_VALUE;
    }
}

