/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import java.io.PrintWriter;
import java.nio.Buffer;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.lwjgl.PointerBuffer;
import org.lwjgl.util.generator.Alternate;
import org.lwjgl.util.generator.AutoSize;
import org.lwjgl.util.generator.BufferObject;
import org.lwjgl.util.generator.CachedResult;
import org.lwjgl.util.generator.Check;
import org.lwjgl.util.generator.Code;
import org.lwjgl.util.generator.Constant;
import org.lwjgl.util.generator.Helper;
import org.lwjgl.util.generator.Indirect;
import org.lwjgl.util.generator.JNITypeTranslator;
import org.lwjgl.util.generator.Mode;
import org.lwjgl.util.generator.NativeTypeTranslator;
import org.lwjgl.util.generator.PointerArray;
import org.lwjgl.util.generator.PointerWrapper;
import org.lwjgl.util.generator.Result;
import org.lwjgl.util.generator.Reuse;
import org.lwjgl.util.generator.TypeMap;
import org.lwjgl.util.generator.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeMethodStubsGenerator {
    private static final String BUFFER_ADDRESS_POSTFIX = "_address";
    public static final String BUFFER_POSITION_POSTFIX = "_position";
    private static final String STRING_LIST_NAME = "_str";
    private static final String POINTER_LIST_NAME = "_ptr";
    private static boolean strLoopDeclared;
    private static boolean ptrLoopDeclared;

    public static void generateNativeMethodStubs(ProcessingEnvironment env, TypeMap type_map, PrintWriter writer, TypeElement d, boolean generate_error_checks, boolean context_specific) {
        for (ExecutableElement method : Utils.getMethods(d)) {
            Alternate alt_annotation = method.getAnnotation(Alternate.class);
            if (alt_annotation != null && (!alt_annotation.nativeAlt() || alt_annotation.skipNative()) || method.getAnnotation(Reuse.class) != null) continue;
            NativeMethodStubsGenerator.generateMethodStub(env, type_map, writer, Utils.getQualifiedClassName(d), method, Mode.NORMAL, generate_error_checks, context_specific);
            if (!Utils.hasMethodBufferObjectParameter(method)) continue;
            NativeMethodStubsGenerator.generateMethodStub(env, type_map, writer, Utils.getQualifiedClassName(d), method, Mode.BUFFEROBJECT, generate_error_checks, context_specific);
        }
    }

    private static void generateParameters(PrintWriter writer, List<? extends VariableElement> params, Mode mode) {
        for (VariableElement variableElement : params) {
            Constant constant_annotation;
            if (variableElement.getAnnotation(Result.class) != null || variableElement.getAnnotation(Helper.class) != null && !variableElement.getAnnotation(Helper.class).passToNative() || (constant_annotation = variableElement.getAnnotation(Constant.class)) != null && constant_annotation.isNative()) continue;
            NativeMethodStubsGenerator.generateParameter(writer, variableElement, mode);
        }
    }

    private static void generateParameter(PrintWriter writer, VariableElement param, Mode mode) {
        writer.print(", ");
        if (mode == Mode.BUFFEROBJECT && param.getAnnotation(BufferObject.class) != null) {
            writer.print("jlong " + param.getSimpleName() + "_buffer_offset");
        } else if (param.getAnnotation(PointerWrapper.class) != null) {
            writer.print("jlong " + param.getSimpleName());
        } else {
            JNITypeTranslator translator = new JNITypeTranslator();
            param.asType().accept(translator, null);
            writer.print(translator.getSignature() + " " + param.getSimpleName());
        }
    }

    private static void generateMethodStub(ProcessingEnvironment env, TypeMap type_map, PrintWriter writer, String interface_name, ExecutableElement method, Mode mode, boolean generate_error_checks, boolean context_specific) {
        boolean resultPreDeclare;
        if (!context_specific && method.getAnnotation(Alternate.class) == null) {
            writer.print("static ");
        } else {
            writer.print("JNIEXPORT ");
        }
        TypeMirror result_type = Utils.getMethodReturnType(method);
        CachedResult cached_result_annotation = method.getAnnotation(CachedResult.class);
        AutoSize auto_size_annotation = method.getAnnotation(AutoSize.class);
        if (method.getAnnotation(PointerWrapper.class) != null) {
            writer.print("jlong");
        } else {
            JNITypeTranslator translator = new JNITypeTranslator();
            result_type.accept(translator, null);
            writer.print(translator.getReturnSignature());
        }
        writer.print(" JNICALL ");
        writer.print(Utils.getQualifiedNativeMethodName(interface_name, method, generate_error_checks, context_specific));
        if (mode == Mode.BUFFEROBJECT) {
            writer.print("BO");
        }
        writer.print("(JNIEnv *env, jclass clazz");
        NativeMethodStubsGenerator.generateParameters(writer, method.getParameters(), mode);
        if (Utils.getNIOBufferType(result_type) != null) {
            if (!(cached_result_annotation != null && cached_result_annotation.isRange() || auto_size_annotation != null && auto_size_annotation.isNative())) {
                writer.print(", jlong result_size");
            }
            if (cached_result_annotation != null) {
                writer.print(", jobject old_buffer");
            }
        }
        if (context_specific) {
            writer.print(", jlong function_pointer");
        }
        writer.println(") {");
        NativeMethodStubsGenerator.generateBufferParameterAddresses(type_map, writer, method, mode);
        Alternate alt_annotation = method.getAnnotation(Alternate.class);
        if (context_specific) {
            String typedef_name = Utils.getTypedefName(method);
            writer.print("\t" + typedef_name + " " + (alt_annotation == null ? method.getSimpleName() : alt_annotation.value()));
            writer.print(" = (" + typedef_name + ")((intptr_t)");
            writer.println("function_pointer);");
        }
        Code code_annotation = method.getAnnotation(Code.class);
        boolean hasResult = !result_type.equals(env.getTypeUtils().getNoType(TypeKind.VOID));
        boolean bl = resultPreDeclare = hasResult && (NativeMethodStubsGenerator.hasPointerArrayInits(method.getParameters()) || code_annotation != null && (code_annotation.nativeAfterVars().length() > 0 || code_annotation.nativeBeforeCall().length() > 0));
        if (resultPreDeclare) {
            NativeMethodStubsGenerator.printResultParam(type_map, writer, method, result_type, true);
        }
        if (code_annotation != null && code_annotation.nativeAfterVars().length() > 0) {
            writer.println(code_annotation.nativeAfterVars());
        }
        NativeMethodStubsGenerator.generatePointerArrayInits(type_map, writer, method.getParameters());
        if (code_annotation != null && code_annotation.nativeBeforeCall().length() > 0) {
            writer.println(code_annotation.nativeBeforeCall());
        }
        writer.print("\t");
        if (resultPreDeclare) {
            writer.print("__result = ");
        } else if (hasResult) {
            NativeMethodStubsGenerator.printResultParam(type_map, writer, method, result_type, false);
        }
        writer.print((alt_annotation == null ? method.getSimpleName() : alt_annotation.value()) + "(");
        NativeMethodStubsGenerator.generateCallParameters(writer, type_map, method.getParameters());
        writer.print(")");
        writer.println(";");
        if (code_annotation != null && code_annotation.nativeAfterCall().length() > 0) {
            writer.println(code_annotation.nativeAfterCall());
        }
        NativeMethodStubsGenerator.generateStringDeallocations(writer, method.getParameters());
        if (!result_type.equals(env.getTypeUtils().getNoType(TypeKind.VOID))) {
            writer.print("\treturn ");
            Class java_result_type = Utils.getJavaType(result_type);
            if (Buffer.class.isAssignableFrom(java_result_type)) {
                if (cached_result_annotation != null) {
                    writer.print("safeNewBufferCached(env, ");
                } else {
                    writer.print("safeNewBuffer(env, ");
                }
            } else if (String.class.equals((Object)java_result_type)) {
                writer.print("NewStringNativeUnsigned(env, ");
            } else if (method.getAnnotation(PointerWrapper.class) != null) {
                writer.print("(intptr_t)");
            }
            writer.print("__result");
            if (Buffer.class.isAssignableFrom(java_result_type)) {
                String size_parameter_name = auto_size_annotation != null && (auto_size_annotation.isNative() || cached_result_annotation != null && cached_result_annotation.isRange()) ? auto_size_annotation.value() : "result_size";
                writer.print(", ");
                Utils.printExtraCallArguments(writer, method, size_parameter_name);
            }
            if (Buffer.class.isAssignableFrom(java_result_type) || String.class.equals((Object)java_result_type)) {
                writer.print(")");
            }
            writer.println(";");
        }
        writer.println("}");
        writer.println();
    }

    private static void printResultParam(TypeMap type_map, PrintWriter writer, ExecutableElement method, TypeMirror result_type, boolean preDeclare) {
        VariableElement result_param = Utils.getResultParameter(method);
        Element return_declaration = result_param == null ? method : result_param;
        NativeTypeTranslator result_translator = new NativeTypeTranslator(type_map, return_declaration);
        result_type.accept(result_translator, null);
        if (preDeclare) {
            writer.print("\t");
        }
        writer.print(result_translator.getSignature() + " " + "__result");
        if (preDeclare) {
            writer.println(";");
        } else {
            writer.print(result_param == null ? " = " : ";\n\t");
        }
    }

    private static void generateCallParameters(PrintWriter writer, TypeMap type_map, List<? extends VariableElement> params) {
        if (params.size() > 0) {
            boolean first = true;
            for (VariableElement variableElement : params) {
                if (variableElement.getAnnotation(Helper.class) != null) continue;
                if (first) {
                    first = false;
                } else {
                    writer.print(", ");
                }
                NativeMethodStubsGenerator.generateCallParameter(writer, type_map, variableElement);
            }
        }
    }

    private static void generateCallParameter(PrintWriter writer, TypeMap type_map, VariableElement param) {
        boolean is_indirect;
        if (param.getAnnotation(Helper.class) != null) {
            return;
        }
        Constant constant_annotation = param.getAnnotation(Constant.class);
        if (constant_annotation != null && constant_annotation.isNative()) {
            writer.print(constant_annotation.value());
            return;
        }
        boolean bl = is_indirect = param.getAnnotation(Indirect.class) != null;
        if (is_indirect || param.getAnnotation(PointerArray.class) != null) {
            writer.print("(");
            NativeTypeTranslator translator = new NativeTypeTranslator(type_map, param);
            param.asType().accept(translator, null);
            writer.print(translator.getSignature());
            writer.print("*)");
        }
        if (param.getAnnotation(PointerWrapper.class) != null) {
            writer.print("(" + param.getAnnotation(PointerWrapper.class).value() + ")(intptr_t)");
        }
        if (param.getAnnotation(Result.class) != null || is_indirect) {
            writer.print("&");
        }
        if (param.getAnnotation(Result.class) != null) {
            writer.print("__result");
        } else {
            writer.print(param.getSimpleName());
            if (param.getAnnotation(PointerArray.class) != null) {
                writer.print(NativeMethodStubsGenerator.getPointerArrayName(Utils.getJavaType(param.asType())));
            } else if (Utils.isAddressableType(param.asType())) {
                writer.print(BUFFER_ADDRESS_POSTFIX);
            }
        }
    }

    private static void generateStringDeallocations(PrintWriter writer, List<? extends VariableElement> params) {
        for (VariableElement variableElement : params) {
            Class java_type = Utils.getJavaType(variableElement.asType());
            if (java_type.equals(String.class) && variableElement.getAnnotation(Result.class) == null) {
                writer.println("\tfree(" + variableElement.getSimpleName() + BUFFER_ADDRESS_POSTFIX + ");");
                continue;
            }
            if (variableElement.getAnnotation(PointerArray.class) == null) continue;
            writer.println("\tfree(" + variableElement.getSimpleName() + NativeMethodStubsGenerator.getPointerArrayName(java_type) + ");");
        }
    }

    private static void generateBufferParameterAddresses(TypeMap type_map, PrintWriter writer, ExecutableElement method, Mode mode) {
        strLoopDeclared = false;
        ptrLoopDeclared = false;
        for (VariableElement variableElement : method.getParameters()) {
            Constant constant_annotation = variableElement.getAnnotation(Constant.class);
            if (variableElement.getAnnotation(Result.class) != null || constant_annotation != null && constant_annotation.isNative() || !Utils.isAddressableType(variableElement.asType())) continue;
            NativeMethodStubsGenerator.generateBufferParameterAddress(type_map, writer, variableElement, mode);
        }
    }

    private static void generateBufferParameterAddress(TypeMap type_map, PrintWriter writer, VariableElement param, Mode mode) {
        Check check_annotation = param.getAnnotation(Check.class);
        PointerArray array_annotation = param.getAnnotation(PointerArray.class);
        Class java_type = Utils.getJavaType(param.asType());
        NativeTypeTranslator translator = new NativeTypeTranslator(type_map, param);
        param.asType().accept(translator, null);
        String native_type = translator.getSignature();
        if (!java_type.isArray() || CharSequence.class.isAssignableFrom(java_type.getComponentType())) {
            writer.print("\t" + native_type + param.getSimpleName());
            writer.print("_address = (");
            writer.print(native_type);
            writer.print(")(intptr_t)");
            if (mode == Mode.BUFFEROBJECT && param.getAnnotation(BufferObject.class) != null) {
                writer.print("offsetToPointer(" + param.getSimpleName() + "_buffer_offset" + ")");
            } else if (Buffer.class.isAssignableFrom(java_type) || java_type.equals(CharSequence.class) || java_type.equals(CharSequence[].class) || PointerBuffer.class.isAssignableFrom(java_type)) {
                writer.print(param.getSimpleName());
            } else if (java_type.equals(String.class)) {
                writer.print("GetStringNativeChars(env, " + param.getSimpleName() + ")");
            } else if (array_annotation == null) {
                throw new RuntimeException("Illegal type " + java_type);
            }
            writer.println(";");
        }
        if (array_annotation != null) {
            String arrayType;
            String n = NativeMethodStubsGenerator.getPointerArrayName(java_type);
            if (POINTER_LIST_NAME.equals(n)) {
                if (n.equals(param.getSimpleName().toString())) {
                    throw new RuntimeException("The name '" + n + "' is not valid for object array arguments annotated with PointerArray");
                }
                arrayType = translator.getSignature(true) + (org.lwjgl.PointerWrapper.class.isAssignableFrom(java_type.getComponentType()) ? " " : "");
                if (!ptrLoopDeclared) {
                    writer.println("\tint " + n + "_i;");
                    writer.println("\tjobject " + n + "_object;");
                    ptrLoopDeclared = true;
                }
            } else {
                if (n.equals(param.getSimpleName().toString())) {
                    throw new RuntimeException("The name '" + n + "' is not valid for arguments annotated with PointerArray");
                }
                arrayType = translator.getSignature(true);
                if (!strLoopDeclared) {
                    writer.println("\tint " + n + "_i;");
                    writer.println("\t" + arrayType + n + "_address;");
                    strLoopDeclared = true;
                }
            }
            writer.print("\t" + arrayType + "*" + param.getSimpleName() + n + " = ");
            if (check_annotation != null && check_annotation.canBeNull()) {
                writer.print(array_annotation.value() + " == 0 ? NULL : ");
            }
            writer.println("(" + arrayType + "*) malloc(" + array_annotation.value() + " * sizeof(" + arrayType + "));");
        }
    }

    private static String getPointerArrayName(Class java_type) {
        Class<?> component_type = java_type.getComponentType();
        if (component_type != null && (Buffer.class.isAssignableFrom(component_type) || org.lwjgl.PointerWrapper.class.isAssignableFrom(component_type))) {
            return POINTER_LIST_NAME;
        }
        return STRING_LIST_NAME;
    }

    private static boolean hasPointerArrayInits(List<? extends VariableElement> params) {
        for (VariableElement variableElement : params) {
            PointerArray pointerArray_annotation = variableElement.getAnnotation(PointerArray.class);
            if (pointerArray_annotation == null) continue;
            return true;
        }
        return false;
    }

    private static void generatePointerArrayInits(TypeMap type_map, PrintWriter writer, List<? extends VariableElement> params) {
        for (VariableElement variableElement : params) {
            PointerArray pointerArray_annotation = variableElement.getAnnotation(PointerArray.class);
            if (pointerArray_annotation == null) continue;
            Class java_type = Utils.getJavaType(variableElement.asType());
            Class<?> component_type = java_type.isArray() ? java_type.getComponentType() : null;
            NativeTypeTranslator translator = new NativeTypeTranslator(type_map, variableElement);
            variableElement.asType().accept(translator, null);
            String n = NativeMethodStubsGenerator.getPointerArrayName(java_type);
            if (POINTER_LIST_NAME.equals(n)) {
                writer.println("\t" + n + "_i = 0;");
                writer.println("\twhile ( " + n + "_i < " + pointerArray_annotation.value() + " ) {");
                writer.println("\t\t" + n + "_object = (*env)->GetObjectArrayElement(env, " + variableElement.getSimpleName() + ", " + n + "_i);");
                writer.print("\t\t" + variableElement.getSimpleName() + n + "[" + n + "_i++] = (" + translator.getSignature(true) + ")");
                if (Buffer.class.isAssignableFrom(component_type)) {
                    writer.println("(*env)->GetDirectBufferAddress(env, " + n + "_object);");
                } else {
                    writer.println("(intptr_t)getPointerWrapperAddress(env, " + n + "_object);");
                }
                writer.println("\t}");
                continue;
            }
            String lengths = pointerArray_annotation.lengths();
            writer.println("\t" + n + "_i = 0;");
            writer.println("\t" + n + "_address = (" + translator.getSignature(true) + ")" + variableElement.getSimpleName() + BUFFER_ADDRESS_POSTFIX + ";");
            writer.println("\twhile ( " + n + "_i < " + pointerArray_annotation.value() + " ) {");
            if (lengths.length() == 0) {
                writer.println("\t\t" + variableElement.getSimpleName() + n + "[" + n + "_i++] = " + n + "_address;");
                writer.println("\t\t" + n + "_address += strlen((const char *)" + n + "_address) + 1;");
            } else {
                writer.println("\t\t" + variableElement.getSimpleName() + n + "[" + n + "_i] = " + n + "_address;");
                writer.println("\t\t" + n + "_address += " + lengths + BUFFER_ADDRESS_POSTFIX + "[" + n + "_i++];");
            }
            writer.println("\t}");
        }
    }
}

