/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import java.nio.Buffer;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.lwjgl.PointerBuffer;
import org.lwjgl.util.generator.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNITypeTranslator
extends SimpleTypeVisitor6<Void, Void> {
    private final StringBuilder signature = new StringBuilder();
    private boolean objectReturn;

    public String getSignature() {
        return this.signature.toString();
    }

    public String getReturnSignature() {
        return this.objectReturn ? "jobject" : this.signature.toString();
    }

    @Override
    public Void visitArray(ArrayType t, Void o) {
        String className = t.getComponentType().toString();
        if ("java.lang.CharSequence".equals(className)) {
            this.signature.append("jlong");
        } else if ("java.nio.ByteBuffer".equals(className)) {
            this.signature.append("jobjectArray");
        } else if ("org.lwjgl.opencl.CLMem".equals(className)) {
            this.signature.append("jobjectArray");
        } else {
            throw new RuntimeException(t + " is not allowed");
        }
        return (Void)this.DEFAULT_VALUE;
    }

    private void visitClassType(DeclaredType t) {
        Class type = Utils.getJavaType(t);
        if (Buffer.class.isAssignableFrom(type) || PointerBuffer.class.isAssignableFrom(type)) {
            this.signature.append("jlong");
            this.objectReturn = true;
        } else {
            this.signature.append("jobject");
        }
    }

    @Override
    public Void visitDeclared(DeclaredType t, Void o) {
        if (t.asElement().getKind().isClass()) {
            this.visitClassType(t);
        }
        return (Void)this.DEFAULT_VALUE;
    }

    @Override
    public Void visitPrimitive(PrimitiveType t, Void o) {
        String type;
        switch (t.getKind()) {
            case LONG: {
                type = "jlong";
                break;
            }
            case INT: {
                type = "jint";
                break;
            }
            case FLOAT: {
                type = "jfloat";
                break;
            }
            case SHORT: {
                type = "jshort";
                break;
            }
            case BYTE: {
                type = "jbyte";
                break;
            }
            case DOUBLE: {
                type = "jdouble";
                break;
            }
            case BOOLEAN: {
                type = "jboolean";
                break;
            }
            default: {
                throw new RuntimeException(t + " is not allowed");
            }
        }
        this.signature.append(type);
        return (Void)this.DEFAULT_VALUE;
    }

    @Override
    public Void visitNoType(NoType t, Void o) {
        this.signature.append(t.toString());
        return (Void)this.DEFAULT_VALUE;
    }
}

