/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.generator;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.lwjgl.util.generator.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldsGenerator {
    private static void validateField(VariableElement field) {
        Object field_value;
        Set<Modifier> modifiers = field.getModifiers();
        if (!(modifiers.size() == 3 && modifiers.contains((Object)Modifier.PUBLIC) && modifiers.contains((Object)Modifier.STATIC) && modifiers.contains((Object)Modifier.FINAL))) {
            throw new RuntimeException("Field " + field.getSimpleName() + " is not declared public static final");
        }
        TypeMirror field_type = field.asType();
        if (!"java.lang.String".equals(field_type.toString())) {
            if (field_type instanceof PrimitiveType) {
                PrimitiveType field_type_prim = (PrimitiveType)field_type;
                TypeKind field_kind = field_type_prim.getKind();
                if (field_kind != TypeKind.INT && field_kind != TypeKind.LONG && field_kind != TypeKind.FLOAT && field_kind != TypeKind.BYTE) {
                    throw new RuntimeException("Field " + field.getSimpleName() + " is not of type 'int', 'long', 'float' or 'byte' " + field_kind.toString());
                }
            } else {
                throw new RuntimeException("Field " + field.getSimpleName() + " is not a primitive type or String");
            }
        }
        if ((field_value = field.getConstantValue()) == null) {
            throw new RuntimeException("Field " + field.getSimpleName() + " has no initial value");
        }
    }

    private static void generateField(PrintWriter writer, VariableElement field, VariableElement prev_field, ProcessingEnvironment env) {
        boolean newBatch;
        String field_value_string;
        FieldsGenerator.validateField(field);
        Object value = field.getConstantValue();
        Class<?> field_value_class = value.getClass();
        if (field_value_class.equals(Integer.class)) {
            field_value_string = "0x" + Integer.toHexString((Integer)field.getConstantValue()).toUpperCase();
        } else if (field_value_class.equals(Long.class)) {
            field_value_string = "0x" + Long.toHexString((Long)field.getConstantValue()).toUpperCase() + 'L';
        } else if (field_value_class.equals(Float.class)) {
            field_value_string = field.getConstantValue() + "f";
        } else if (value.getClass().equals(Byte.class)) {
            field_value_string = "0x" + Integer.toHexString(((Byte)field.getConstantValue()).byteValue()).toUpperCase();
        } else if (field_value_class.equals(String.class)) {
            field_value_string = "\"" + field.getConstantValue() + "\"";
        } else {
            throw new RuntimeException("Field is of unexpected type. This means there is a bug in validateField().");
        }
        boolean hadDoc = prev_field != null && env.getElementUtils().getDocComment(prev_field) != null;
        boolean hasDoc = env.getElementUtils().getDocComment(field) != null;
        boolean bl = newBatch = prev_field == null || !prev_field.asType().equals(field.asType()) || !hadDoc && env.getElementUtils().getDocComment(field) != null || hadDoc && hasDoc && !env.getElementUtils().getDocComment(prev_field).equals(env.getElementUtils().getDocComment(field));
        if (newBatch) {
            if (prev_field != null) {
                writer.println(";\n");
            }
            Utils.printDocComment(writer, field, env);
            writer.print("\tpublic static final " + field.asType().toString() + " " + field.getSimpleName() + " = " + field_value_string);
        } else {
            writer.print(",\n\t\t" + field.getSimpleName() + " = " + field_value_string);
        }
    }

    public static void generateFields(ProcessingEnvironment env, PrintWriter writer, Collection<? extends VariableElement> fields) {
        if (0 < fields.size()) {
            writer.println();
            VariableElement prev_field = null;
            for (VariableElement variableElement : fields) {
                FieldsGenerator.generateField(writer, variableElement, prev_field, env);
                prev_field = variableElement;
            }
            writer.println(";");
        }
    }
}

