/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengles.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.test.opengles.util.GLObject;

public class Shader
implements GLObject {
    protected static ByteBuffer fileBuffer = BufferUtils.createByteBuffer(10240);
    private int type;
    private int ID;

    public Shader() {
    }

    public Shader(int type, CharSequence source) {
        this.createFromSource(type, source);
    }

    public int getID() {
        return this.ID;
    }

    public int getType() {
        return this.type;
    }

    public void destroy() {
        if (this.ID == 0) {
            throw new IllegalStateException("The shader has not been created");
        }
        GLES20.glDeleteShader(this.ID);
        this.ID = 0;
    }

    public void createFromFile(int type, ClassLoader loader, String file) throws IOException {
        byte character;
        InputStream inputStream = loader.getResourceAsStream(file);
        if (inputStream == null) {
            throw new IllegalArgumentException("A shader source file could not be found: " + file);
        }
        BufferedInputStream stream = new BufferedInputStream(inputStream);
        while ((character = (byte)stream.read()) != -1) {
            fileBuffer.put(character);
        }
        fileBuffer.flip();
        stream.close();
        byte[] array = new byte[fileBuffer.remaining()];
        fileBuffer.get(array);
        String source = new String(array);
        fileBuffer.clear();
        this.createFromSource(type, source);
    }

    public void createFromSource(int type, CharSequence source) {
        if (this.ID != 0) {
            throw new IllegalStateException("The shader has already been created");
        }
        this.type = type;
        this.ID = GLES20.glCreateShader(type);
        GLES20.glShaderSource(this.ID, source);
        GLES20.glCompileShader(this.ID);
        if (GLES20.glGetShaderi(this.ID, 35713) == 0) {
            this.printInfoLog();
            this.destroy();
            throw new RuntimeException("A compilation error occured in a shader.");
        }
    }

    public void printInfoLog() {
        if (this.ID == 0) {
            throw new IllegalStateException("The shader has not been created");
        }
        int logLength = GLES20.glGetShaderi(this.ID, 35716);
        if (logLength <= 1) {
            return;
        }
        System.out.println("\nInfo Log of Shader Object: " + this.ID);
        System.out.println("--------------------------");
        System.out.println(GLES20.glGetShaderInfoLog(this.ID, logLength));
    }
}

