/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengles.util;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;

public final class ImmediateModeBuffer {
    private FloatBuffer buffer;

    public ImmediateModeBuffer(int startSize) {
        this.buffer = BufferUtils.createFloatBuffer(startSize);
    }

    private void checkSize(int count) {
        while (this.buffer.remaining() < count) {
            FloatBuffer newBuffer = BufferUtils.createFloatBuffer(this.buffer.capacity() << 1);
            this.buffer.flip();
            newBuffer.put(this.buffer);
            this.buffer = newBuffer;
        }
    }

    public FloatBuffer getBuffer() {
        this.buffer.flip();
        return this.buffer;
    }

    public void glVertex2f(float x, float y) {
        this.checkSize(2);
        this.buffer.put(x).put(y);
    }

    public void glVertex3f(float x, float y, float z) {
        this.checkSize(3);
        this.buffer.put(x).put(y).put(z);
    }

    public void glVertex4f(float x, float y, float z, float w) {
        this.checkSize(4);
        this.buffer.put(x).put(y).put(z).put(w);
    }

    public void glNormal3f(float x, float y, float z) {
        this.checkSize(3);
        this.buffer.put(x).put(y).put(z);
    }

    public void glTexCoord2f(float s, float t) {
        this.checkSize(2);
        this.buffer.put(s).put(t);
    }
}

