/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengles.util;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.test.opengles.util.BufferObjectArray;

public class Geometry {
    protected BufferObjectArray bo;
    protected final List<DrawCommand> drawCommands = new ArrayList<DrawCommand>(4);

    public Geometry() {
    }

    public Geometry(FloatBuffer buffer) {
        this.update(buffer);
    }

    public void update(FloatBuffer buffer) {
        if (this.bo != null) {
            this.destroy();
        }
        this.bo = new BufferObjectArray(35044, buffer);
    }

    public void bind() {
        this.bo.enable();
    }

    public void draw() {
        for (DrawCommand command : this.drawCommands) {
            command.draw();
        }
    }

    public void destroy() {
        this.bo.destroy();
        this.bo = null;
        this.drawCommands.clear();
    }

    public int addDrawCommand(int mode, int first, int count) {
        this.drawCommands.add(new DrawCommand(mode, first, count));
        return count;
    }

    public static float sin(float r) {
        return (float)Math.sin(r);
    }

    public static float cos(float r) {
        return (float)Math.cos(r);
    }

    protected static class DrawCommand {
        private int mode;
        private int first;
        private int count;

        private DrawCommand(int mode, int first, int count) {
            this.mode = mode;
            this.first = first;
            this.count = count;
        }

        void draw() {
            GLES20.glDrawArrays(this.mode, this.first, this.count);
        }
    }
}

