/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengles.util;

import java.util.Stack;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GLMatrix {
    public static final int GL_MODELVIEW = 5888;
    public static final int GL_PROJECTION = 5889;
    private static final float PI = (float)Math.PI;
    private static final Stack<Matrix4f> mvMatrixStack = new Stack();
    private static final Stack<Matrix4f> pMatrixStack = new Stack();
    private static final Matrix4f m4f = new Matrix4f();
    private static final Vector3f v3f = new Vector3f();
    private static int mode = 5888;

    private GLMatrix() {
    }

    private static Stack<Matrix4f> getCurrentStack() {
        switch (mode) {
            case 5888: {
                return mvMatrixStack;
            }
            case 5889: {
                return pMatrixStack;
            }
        }
        return null;
    }

    private static Matrix4f getCurrentMatrix() {
        return GLMatrix.getCurrentStack().peek();
    }

    public static void glMatrixMode(int mode) {
        if (mode != 5888 && mode != 5889) {
            throw new IllegalArgumentException("Invalid matrix mode specified: " + mode);
        }
        GLMatrix.mode = mode;
    }

    public static void glPushMatrix() {
        Stack<Matrix4f> stack = GLMatrix.getCurrentStack();
        stack.push(new Matrix4f(stack.peek()));
    }

    public static void glPopMatrix() {
        Stack<Matrix4f> stack = GLMatrix.getCurrentStack();
        if (stack.size() == 1) {
            throw new IllegalStateException("The last matrix in the stack cannot be popped.");
        }
        GLMatrix.getCurrentStack().pop();
    }

    public static void glLoadIdentity() {
        Matrix4f m = GLMatrix.getCurrentMatrix();
        m.setIdentity();
    }

    public static void glLoadMatrix(Matrix4f s) {
        GLMatrix.getCurrentMatrix().load(s);
    }

    public static void glMultMatrix(Matrix4f m) {
        Matrix4f c = GLMatrix.getCurrentMatrix();
        Matrix4f.mul(c, m, c);
    }

    public static void glTranslatef(float x, float y, float z) {
        Matrix4f m = GLMatrix.getCurrentMatrix();
        v3f.set(x, y, z);
        m.translate(v3f);
    }

    public static void glRotatef(float angle, float x, float y, float z) {
        Matrix4f m = GLMatrix.getCurrentMatrix();
        v3f.set(x, y, z);
        m.rotate((float)Math.toRadians(angle), v3f);
    }

    public static void glOrtho(float l, float r, float b, float t, float n, float f) {
        Matrix4f m = m4f;
        m.setIdentity();
        m.m00 = 2.0f / (r - l);
        m.m30 = -(r + l) / (r - l);
        m.m11 = 2.0f / (t - b);
        m.m31 = -(t + b) / (t - b);
        m.m22 = -2.0f / (f - n);
        m.m32 = -(f + n) / (f - n);
        GLMatrix.glMultMatrix(m);
    }

    public static void glFrustum(float l, float r, float b, float t, float n, float f) {
        Matrix4f m = m4f;
        m.setIdentity();
        m.m00 = 2.0f * n / (r - l);
        m.m20 = (r + l) / (r - l);
        m.m11 = 2.0f * n / (t - b);
        m.m21 = (t + b) / (t - b);
        m.m22 = -(f + n) / (f - n);
        m.m32 = -(2.0f * f * n) / (f - n);
        m.m23 = -1.0f;
        m.m33 = 0.0f;
        GLMatrix.glMultMatrix(m);
    }

    public static void gluPerspective(float fovy, float aspect, float zNear, float zFar) {
        float radians = fovy / 2.0f * (float)Math.PI / 180.0f;
        float deltaZ = zFar - zNear;
        float sine = (float)Math.sin(radians);
        if (deltaZ == 0.0f || sine == 0.0f || aspect == 0.0f) {
            return;
        }
        float cotangent = (float)Math.cos(radians) / sine;
        Matrix4f m = m4f;
        m.setIdentity();
        m.m00 = cotangent / aspect;
        m.m11 = cotangent;
        m.m22 = -(zFar + zNear) / deltaZ;
        m.m23 = -1.0f;
        m.m32 = -2.0f * zNear * zFar / deltaZ;
        m.m33 = 0.0f;
        GLMatrix.glMultMatrix(m);
    }

    public static void glGetMatrix(Matrix4f d) {
        d.load(GLMatrix.getCurrentMatrix());
    }

    static {
        mvMatrixStack.push(new Matrix4f());
        pMatrixStack.push(new Matrix4f());
    }
}

