/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengles.util;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.opengles.OESMapbuffer;
import org.lwjgl.test.opengles.util.GLObject;

abstract class BufferObject
implements GLObject {
    protected final int ID = GLES20.glGenBuffers();
    protected int target;
    protected int usage;
    private int size;

    protected BufferObject(int type, int usage) {
        this.target = type;
        this.usage = usage;
    }

    protected BufferObject(int type, int usage, Buffer buffer) {
        this(type, usage);
        this.setData(buffer);
    }

    protected BufferObject(int type, int usage, int dataSize) {
        this(type, usage);
        this.setData(dataSize);
    }

    public final int getID() {
        return this.ID;
    }

    public void destroy() {
        GLES20.glDeleteBuffers(this.ID);
    }

    public final int getTarget() {
        return this.target;
    }

    public final int getUsage() {
        return this.usage;
    }

    public final int getSize() {
        return this.size;
    }

    public abstract void enable();

    public abstract void disable();

    public final void setData(Buffer buffer) {
        this.enable();
        if (buffer instanceof ByteBuffer) {
            GLES20.glBufferData(this.target, (ByteBuffer)buffer, this.usage);
            this.size = buffer.remaining();
        } else if (buffer instanceof ShortBuffer) {
            GLES20.glBufferData(this.target, (ShortBuffer)buffer, this.usage);
            this.size = buffer.remaining() << 1;
        } else if (buffer instanceof IntBuffer) {
            GLES20.glBufferData(this.target, (IntBuffer)buffer, this.usage);
            this.size = buffer.remaining() << 2;
        } else if (buffer instanceof FloatBuffer) {
            GLES20.glBufferData(this.target, (FloatBuffer)buffer, this.usage);
            this.size = buffer.remaining() << 2;
        }
        this.disable();
    }

    public final void setData(int dataSize) {
        this.enable();
        GLES20.glBufferData(this.target, dataSize, this.usage);
        this.size = dataSize;
        this.disable();
    }

    public final ByteBuffer map(int access, ByteBuffer oldBuffer) {
        return OESMapbuffer.glMapBufferOES(this.target, access, oldBuffer);
    }

    public final ByteBuffer map(int access, int length, ByteBuffer oldBuffer) {
        return OESMapbuffer.glMapBufferOES(this.target, access, length, oldBuffer);
    }

    public final boolean unmap() {
        return OESMapbuffer.glUnmapBufferOES(this.target);
    }
}

