/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengles;

import java.lang.reflect.Field;
import java.nio.FloatBuffer;
import java.util.StringTokenizer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengles.ContextCapabilities;
import org.lwjgl.opengles.GLContext;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.opengles.PixelFormat;
import org.lwjgl.opengles.PowerManagementEventException;
import org.lwjgl.test.opengles.util.GLLight;
import org.lwjgl.test.opengles.util.GLMatrix;
import org.lwjgl.test.opengles.util.Geometry;
import org.lwjgl.test.opengles.util.ImmediateModeBuffer;
import org.lwjgl.test.opengles.util.Shader;
import org.lwjgl.test.opengles.util.ShaderProgram;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;

public class Gears {
    private boolean run = true;
    private float view_rotx = 20.0f;
    private float view_roty = 30.0f;
    private float view_rotz = 0.0f;
    private Gear gear1;
    private Gear gear2;
    private Gear gear3;
    private float angle = 0.0f;
    private Shader vsh;
    private Shader fsh;
    private ShaderProgram program;
    private int LIGHT_POS;
    private int MVP;
    private int NM;
    private int GEAR_COLOR;
    private int vPosition;
    private int vNormal;
    private final Matrix4f p = new Matrix4f();
    private final Matrix4f mv = new Matrix4f();
    private final Matrix4f mvp = new Matrix4f();
    private final FloatBuffer m4fBuffer = BufferUtils.createFloatBuffer(16);
    private final FloatBuffer m3fBuffer = BufferUtils.createFloatBuffer(9);

    public static void main(String[] args) {
        new Gears().execute();
        System.exit(0);
    }

    private void execute() {
        Field[] field;
        try {
            this.init();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            System.out.println("Failed to initialize Gears.");
            return;
        }
        System.out.println("\nGL RENDERER: " + GLES20.glGetString(7937));
        System.out.println("GL VENDOR: " + GLES20.glGetString(7936));
        System.out.println("GL VERSION: " + GLES20.glGetString(7938));
        System.out.println("GL_SHADING_LANGUAGE_VERSION: " + GLES20.glGetString(35724));
        System.out.println("GL_EXTENSIONS = " + GLES20.glGetString(7939));
        ContextCapabilities caps = GLContext.getCapabilities();
        System.out.println();
        for (Field f : field = ContextCapabilities.class.getFields()) {
            if (!f.getName().startsWith("GL_")) continue;
            try {
                System.out.println(f.getName() + " - " + f.getBoolean(caps));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        System.out.println();
        String extensions = GLES20.glGetString(7939);
        StringTokenizer tokenizer = new StringTokenizer(extensions);
        while (tokenizer.hasMoreTokens()) {
            String ext = tokenizer.nextToken();
            try {
                if (caps.getClass().getField(ext).getBoolean(caps)) continue;
                System.out.println("-- Extension exposed but functions are missing: " + ext);
            }
            catch (NoSuchFieldException e) {
                System.out.println("-- No LWJGL support for extension: " + ext);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.loop();
        this.destroy();
    }

    private void destroy() {
        this.program.destroy();
        this.fsh.destroy();
        this.vsh.destroy();
        this.gear3.destroy();
        this.gear2.destroy();
        this.gear1.destroy();
        Display.destroy();
    }

    private void loop() {
        long lastFrameTime = Sys.getTime();
        long startTime = System.currentTimeMillis() + 5000L;
        long fps = 0L;
        while (this.run) {
            if (!Display.isVisible()) {
                Thread.yield();
                continue;
            }
            long frameStart = Sys.getTime();
            float frameTime = (float)((double)(frameStart - lastFrameTime) / (double)Sys.getTimerResolution());
            lastFrameTime = frameStart;
            this.angle += frameTime * 120.0f;
            this.handleInput();
            GLES20.glClear(16640);
            GLMatrix.glPushMatrix();
            GLMatrix.glRotatef(this.view_rotx, 1.0f, 0.0f, 0.0f);
            GLMatrix.glRotatef(this.view_roty, 0.0f, 1.0f, 0.0f);
            GLMatrix.glRotatef(this.view_rotz, 0.0f, 0.0f, 1.0f);
            GLMatrix.glPushMatrix();
            GLMatrix.glTranslatef(-3.0f, -2.0f, 0.0f);
            GLMatrix.glRotatef(this.angle, 0.0f, 0.0f, 1.0f);
            this.gear1.render();
            GLMatrix.glPopMatrix();
            GLMatrix.glPushMatrix();
            GLMatrix.glTranslatef(3.1f, -2.0f, 0.0f);
            GLMatrix.glRotatef(-2.0f * this.angle - 9.0f, 0.0f, 0.0f, 1.0f);
            this.gear2.render();
            GLMatrix.glPopMatrix();
            GLMatrix.glPushMatrix();
            GLMatrix.glTranslatef(-3.1f, 4.2f, 0.0f);
            GLMatrix.glRotatef(-2.0f * this.angle - 25.0f, 0.0f, 0.0f, 1.0f);
            this.gear3.render();
            GLMatrix.glPopMatrix();
            GLMatrix.glPopMatrix();
            try {
                Display.update();
            }
            catch (PowerManagementEventException e) {
                e.printStackTrace();
            }
            if (startTime > System.currentTimeMillis()) {
                ++fps;
            } else {
                long timeUsed = 5000L + (startTime - System.currentTimeMillis());
                startTime = System.currentTimeMillis() + 5000L;
                System.out.println(fps + " frames in " + (float)timeUsed / 1000.0f + " seconds = " + (float)fps / ((float)timeUsed / 1000.0f));
                fps = 0L;
            }
            if (!Display.isCloseRequested()) continue;
            break;
        }
    }

    private void handleInput() {
        if (Keyboard.getNumKeyboardEvents() != 0) {
            while (Keyboard.next()) {
                if (Keyboard.getEventKeyState()) continue;
                int key = Keyboard.getEventKey();
                switch (key) {
                    case 1: {
                        this.run = false;
                    }
                }
            }
        }
        while (Mouse.next()) {
        }
    }

    private void init() throws LWJGLException {
        int WIDTH = 640;
        int HEIGHT = 480;
        Display.setLocation((Display.getDisplayMode().getWidth() - 640) / 2, (Display.getDisplayMode().getHeight() - 480) / 2);
        try {
            Display.setDisplayMode(new DisplayMode(640, 480));
        }
        catch (PowerManagementEventException e) {
            e.printStackTrace();
        }
        Display.setTitle("Gears");
        Display.create(new PixelFormat());
        GLES20.glViewport(0, 0, 640, 480);
        GLES20.glFrontFace(2305);
        GLES20.glCullFace(1029);
        GLES20.glEnable(2884);
        GLES20.glEnable(2929);
        Vector3f lp = new Vector3f(5.0f, 5.0f, 10.0f);
        lp.normalise();
        GLLight.glLight(16384, 4611, lp.getX(), lp.getY(), lp.getZ(), 0.0f);
        this.gear1 = new Gear(Gears.gear(1.0f, 4.0f, 1.0f, 20, 0.7f), new float[]{0.8f, 0.1f, 0.0f, 1.0f});
        this.gear2 = new Gear(Gears.gear(0.5f, 2.0f, 2.0f, 10, 0.7f), new float[]{0.0f, 0.8f, 0.2f, 1.0f});
        this.gear3 = new Gear(Gears.gear(1.3f, 2.0f, 0.5f, 10, 0.7f), new float[]{0.2f, 0.2f, 1.0f, 1.0f});
        GLMatrix.glMatrixMode(5889);
        GLMatrix.glLoadIdentity();
        float h = 1.0f;
        GLMatrix.glFrustum(-1.0f, 1.0f, -1.0f, 1.0f, 5.0f, 60.0f);
        GLMatrix.glMatrixMode(5888);
        GLMatrix.glLoadIdentity();
        GLMatrix.glTranslatef(0.0f, 0.0f, -40.0f);
        this.vsh = new Shader(35633, "uniform highp vec4 LIGHT_POS;\nuniform highp mat4 MODEL_VIEW_PROJECTION_MATRIX;\nuniform mediump mat3 NORMAL_MATRIX;\nuniform lowp vec3 GEAR_COLOR;\nattribute highp vec3 vPosition;\nattribute mediump vec3 vNormal;\nvarying lowp vec3 color;\nvoid main(void) {\n\tgl_Position = MODEL_VIEW_PROJECTION_MATRIX * vec4(vPosition, 1.0);\n\tvec3 normal = NORMAL_MATRIX * vNormal;\n\tcolor = max(dot(normal, vec3(LIGHT_POS)), 0.0) * GEAR_COLOR + vec3(0.05);\n}");
        this.fsh = new Shader(35632, "varying lowp vec3 color;\nvoid main(void) {\n\tgl_FragColor = vec4(color, 1.0);\n}");
        this.program = new ShaderProgram(this.vsh, this.fsh);
        this.program.enable();
        this.LIGHT_POS = this.program.getUniformLocation("LIGHT_POS");
        this.MVP = this.program.getUniformLocation("MODEL_VIEW_PROJECTION_MATRIX");
        this.NM = this.program.getUniformLocation("NORMAL_MATRIX");
        this.GEAR_COLOR = this.program.getUniformLocation("GEAR_COLOR");
        this.vPosition = this.program.getAttributeLocation("vPosition");
        this.vNormal = this.program.getAttributeLocation("vNormal");
        GLES20.glEnableVertexAttribArray(this.vNormal);
        GLES20.glEnableVertexAttribArray(this.vPosition);
    }

    private static Geometry gear(float inner_radius, float outer_radius, float width, int teeth, float tooth_depth) {
        float angle;
        int i;
        float r0 = inner_radius;
        float r1 = outer_radius - tooth_depth / 2.0f;
        float r2 = outer_radius + tooth_depth / 2.0f;
        float da = (float)Math.PI * 2 / (float)teeth / 4.0f;
        Geometry gear = new Geometry();
        ImmediateModeBuffer imb = new ImmediateModeBuffer(1024);
        int lastDrawIndex = 0;
        lastDrawIndex += gear.addDrawCommand(5, lastDrawIndex, teeth * 4 + 2);
        for (i = 0; i <= teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            imb.glNormal3f(0.0f, 0.0f, 1.0f);
            imb.glVertex3f(r0 * Geometry.cos(angle), r0 * Geometry.sin(angle), width * 0.5f);
            imb.glNormal3f(0.0f, 0.0f, 1.0f);
            imb.glVertex3f(r1 * Geometry.cos(angle), r1 * Geometry.sin(angle), width * 0.5f);
            if (i >= teeth) continue;
            imb.glNormal3f(0.0f, 0.0f, 1.0f);
            imb.glVertex3f(r0 * Geometry.cos(angle), r0 * Geometry.sin(angle), width * 0.5f);
            imb.glNormal3f(0.0f, 0.0f, 1.0f);
            imb.glVertex3f(r1 * Geometry.cos(angle + 3.0f * da), r1 * Geometry.sin(angle + 3.0f * da), width * 0.5f);
        }
        for (i = 0; i < teeth; ++i) {
            lastDrawIndex += gear.addDrawCommand(5, lastDrawIndex, 4);
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            imb.glNormal3f(0.0f, 0.0f, 1.0f);
            imb.glVertex3f(r1 * Geometry.cos(angle), r1 * Geometry.sin(angle), width * 0.5f);
            imb.glNormal3f(0.0f, 0.0f, 1.0f);
            imb.glVertex3f(r2 * Geometry.cos(angle + da), r2 * Geometry.sin(angle + da), width * 0.5f);
            imb.glNormal3f(0.0f, 0.0f, 1.0f);
            imb.glVertex3f(r1 * Geometry.cos(angle + 3.0f * da), r1 * Geometry.sin(angle + 3.0f * da), width * 0.5f);
            imb.glNormal3f(0.0f, 0.0f, 1.0f);
            imb.glVertex3f(r2 * Geometry.cos(angle + 2.0f * da), r2 * Geometry.sin(angle + 2.0f * da), width * 0.5f);
        }
        lastDrawIndex += gear.addDrawCommand(5, lastDrawIndex, (teeth + 1) * 4);
        for (i = 0; i <= teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            imb.glNormal3f(0.0f, 0.0f, 1.0f);
            imb.glVertex3f(r1 * Geometry.cos(angle), r1 * Geometry.sin(angle), -width * 0.5f);
            imb.glNormal3f(0.0f, 0.0f, 1.0f);
            imb.glVertex3f(r0 * Geometry.cos(angle), r0 * Geometry.sin(angle), -width * 0.5f);
            imb.glNormal3f(0.0f, 0.0f, 1.0f);
            imb.glVertex3f(r1 * Geometry.cos(angle + 3.0f * da), r1 * Geometry.sin(angle + 3.0f * da), -width * 0.5f);
            imb.glNormal3f(0.0f, 0.0f, 1.0f);
            imb.glVertex3f(r0 * Geometry.cos(angle), r0 * Geometry.sin(angle), -width * 0.5f);
        }
        for (i = 0; i < teeth; ++i) {
            lastDrawIndex += gear.addDrawCommand(5, lastDrawIndex, 4);
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            imb.glNormal3f(0.0f, 0.0f, 1.0f);
            imb.glVertex3f(r1 * Geometry.cos(angle + 3.0f * da), r1 * Geometry.sin(angle + 3.0f * da), -width * 0.5f);
            imb.glNormal3f(0.0f, 0.0f, 1.0f);
            imb.glVertex3f(r2 * Geometry.cos(angle + 2.0f * da), r2 * Geometry.sin(angle + 2.0f * da), -width * 0.5f);
            imb.glNormal3f(0.0f, 0.0f, 1.0f);
            imb.glVertex3f(r1 * Geometry.cos(angle), r1 * Geometry.sin(angle), -width * 0.5f);
            imb.glNormal3f(0.0f, 0.0f, 1.0f);
            imb.glVertex3f(r2 * Geometry.cos(angle + da), r2 * Geometry.sin(angle + da), -width * 0.5f);
        }
        lastDrawIndex += gear.addDrawCommand(5, lastDrawIndex, teeth * 8 + 2);
        for (i = 0; i < teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            imb.glNormal3f(Geometry.cos(angle), Geometry.sin(angle), 0.0f);
            imb.glVertex3f(r1 * Geometry.cos(angle), r1 * Geometry.sin(angle), width * 0.5f);
            imb.glNormal3f(Geometry.cos(angle), Geometry.sin(angle), 0.0f);
            imb.glVertex3f(r1 * Geometry.cos(angle), r1 * Geometry.sin(angle), -width * 0.5f);
            float u = r2 * Geometry.cos(angle + da) - r1 * Geometry.cos(angle);
            float v = r2 * Geometry.sin(angle + da) - r1 * Geometry.sin(angle);
            float len = (float)Math.sqrt(u * u + v * v);
            imb.glNormal3f(v /= len, -(u /= len), 0.0f);
            imb.glVertex3f(r2 * Geometry.cos(angle + da), r2 * Geometry.sin(angle + da), width * 0.5f);
            imb.glNormal3f(v, -u, 0.0f);
            imb.glVertex3f(r2 * Geometry.cos(angle + da), r2 * Geometry.sin(angle + da), -width * 0.5f);
            imb.glNormal3f(Geometry.cos(angle), Geometry.sin(angle), 0.0f);
            imb.glVertex3f(r2 * Geometry.cos(angle + 2.0f * da), r2 * Geometry.sin(angle + 2.0f * da), width * 0.5f);
            imb.glNormal3f(Geometry.cos(angle), Geometry.sin(angle), 0.0f);
            imb.glVertex3f(r2 * Geometry.cos(angle + 2.0f * da), r2 * Geometry.sin(angle + 2.0f * da), -width * 0.5f);
            u = r1 * Geometry.cos(angle + 3.0f * da) - r2 * Geometry.cos(angle + 2.0f * da);
            v = r1 * Geometry.sin(angle + 3.0f * da) - r2 * Geometry.sin(angle + 2.0f * da);
            imb.glNormal3f(v, -u, 0.0f);
            imb.glVertex3f(r1 * Geometry.cos(angle + 3.0f * da), r1 * Geometry.sin(angle + 3.0f * da), width * 0.5f);
            imb.glNormal3f(v, -u, 0.0f);
            imb.glVertex3f(r1 * Geometry.cos(angle + 3.0f * da), r1 * Geometry.sin(angle + 3.0f * da), -width * 0.5f);
        }
        imb.glNormal3f(Geometry.cos(0.0f), Geometry.sin(0.0f), 0.0f);
        imb.glVertex3f(r1 * Geometry.cos(0.0f), r1 * Geometry.sin(0.0f), width * 0.5f);
        imb.glNormal3f(Geometry.cos(0.0f), Geometry.sin(0.0f), 0.0f);
        imb.glVertex3f(r1 * Geometry.cos(0.0f), r1 * Geometry.sin(0.0f), -width * 0.5f);
        lastDrawIndex += gear.addDrawCommand(5, lastDrawIndex, (teeth + 1) * 2);
        for (i = 0; i <= teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            imb.glNormal3f(-Geometry.cos(angle), -Geometry.sin(angle), 0.0f);
            imb.glVertex3f(r0 * Geometry.cos(angle), r0 * Geometry.sin(angle), -width * 0.5f);
            imb.glNormal3f(-Geometry.cos(angle), -Geometry.sin(angle), 0.0f);
            imb.glVertex3f(r0 * Geometry.cos(angle), r0 * Geometry.sin(angle), width * 0.5f);
        }
        gear.update(imb.getBuffer());
        return gear;
    }

    private class Gear {
        private final Geometry geom;
        private final float[] color;

        Gear(Geometry geom, float[] color) {
            this.geom = geom;
            this.color = color;
        }

        void render() {
            GLES20.glUniform3f(Gears.this.GEAR_COLOR, this.color[0], this.color[1], this.color[2]);
            GLLight.setUniform4f(Gears.this.LIGHT_POS, 16384, 4611);
            GLMatrix.glMatrixMode(5889);
            GLMatrix.glGetMatrix(Gears.this.p);
            GLMatrix.glMatrixMode(5888);
            GLMatrix.glGetMatrix(Gears.this.mv);
            Matrix4f.mul(Gears.this.p, Gears.this.mv, Gears.this.mvp);
            Gears.this.mvp.store(Gears.this.m4fBuffer);
            Gears.this.m4fBuffer.flip();
            GLES20.glUniformMatrix4(Gears.this.MVP, false, Gears.this.m4fBuffer);
            Gears.this.mv.invert();
            Gears.this.mv.transpose();
            Gears.this.mv.store3f(Gears.this.m3fBuffer);
            Gears.this.m3fBuffer.flip();
            GLES20.glUniformMatrix3(Gears.this.NM, false, Gears.this.m3fBuffer);
            this.geom.bind();
            int stride = 24;
            GLES20.glVertexAttribPointer(Gears.this.vNormal, 3, 5126, false, 24, 0L);
            GLES20.glVertexAttribPointer(Gears.this.vPosition, 3, 5126, false, 24, 12L);
            this.geom.draw();
        }

        void destroy() {
            this.geom.destroy();
        }
    }
}

