/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.applet;

import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.opengl.AWTGLCanvas;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.test.applet.Test;
import org.lwjgl.util.WaveData;

public class OpenAL
extends AWTGLCanvas
implements Test {
    float angle;
    IntBuffer buffers = BufferUtils.createIntBuffer(1);
    IntBuffer sources = BufferUtils.createIntBuffer(1);

    public OpenAL() throws LWJGLException {
        try {
            AL.create();
        }
        catch (Exception e) {
            System.out.println("Unable to create OpenAL.\nPlease make sure that OpenAL is available on this system. Exception: " + e);
            return;
        }
        Thread t = new Thread(){

            public void run() {
                while (true) {
                    if (OpenAL.this.isVisible()) {
                        OpenAL.this.repaint();
                    }
                    Display.sync(60);
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    private void playOpenAL() {
        this.buffers.position(0).limit(1);
        AL10.alGenBuffers(this.buffers);
        int lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        this.sources.position(0).limit(1);
        AL10.alGenSources(this.sources);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        WaveData wavefile = WaveData.create(this.getClass().getClassLoader().getResourceAsStream("Footsteps.wav"));
        AL10.alBufferData(this.buffers.get(0), wavefile.format, wavefile.data, wavefile.samplerate);
        wavefile.dispose();
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        AL10.alSourcei(this.sources.get(0), 4105, this.buffers.get(0));
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        AL10.alSourcei(this.sources.get(0), 4103, 1);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        AL10.alSourcePlay(this.sources.get(0));
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
    }

    private void exit(int error) {
        System.out.println("OpenAL Error: " + AL10.alGetString(error));
    }

    public void paintGL() {
        GL11.glClear(16384);
        GL11.glMatrixMode(2983);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, 640.0, 0.0, 480.0, 1.0, -1.0);
        GL11.glMatrixMode(2982);
        GL11.glPushMatrix();
        GL11.glTranslatef(320.0f, 240.0f, 0.0f);
        GL11.glRotatef(this.angle, 0.0f, 0.0f, 1.0f);
        GL11.glBegin(7);
        GL11.glVertex2i(-50, -50);
        GL11.glVertex2i(50, -50);
        GL11.glVertex2i(50, 50);
        GL11.glVertex2i(-50, 50);
        GL11.glEnd();
        GL11.glPopMatrix();
        this.angle += 1.0f;
        try {
            this.swapBuffers();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start() {
        this.playOpenAL();
    }

    public void stop() {
        AL10.alSourceStop(this.sources.get(0));
        int lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        this.sources.position(0).limit(1);
        AL10.alDeleteSources(this.sources);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        this.buffers.position(0).limit(1);
        AL10.alDeleteBuffers(this.buffers);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        AL.destroy();
    }
}

