/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.FastIntMap;
import org.lwjgl.opengles.GLES20;

final class StateTracker {
    private static StateTracker tracker = new StateTracker();
    int elementArrayBuffer;
    int arrayBuffer;
    int pixelPackBuffer;
    int pixelUnpackBuffer;
    Buffer[] glVertexAttribPointer_buffer;
    private final FastIntMap<VAOState> vaoMap = new FastIntMap();
    int vertexArrayObject;

    StateTracker() {
    }

    void init() {
        this.glVertexAttribPointer_buffer = new Buffer[GLES20.glGetInteger(34921)];
    }

    static StateTracker getTracker() {
        return tracker;
    }

    static void bindBuffer(int target, int buffer) {
        StateTracker tracker = StateTracker.getTracker();
        switch (target) {
            case 34962: {
                tracker.arrayBuffer = buffer;
                break;
            }
            case 34963: {
                tracker.elementArrayBuffer = buffer;
                break;
            }
            case 35051: {
                tracker.pixelPackBuffer = buffer;
                break;
            }
            case 35052: {
                tracker.pixelUnpackBuffer = buffer;
            }
        }
    }

    static void bindVAO(int array) {
        FastIntMap<VAOState> vaoMap = StateTracker.tracker.vaoMap;
        if (!vaoMap.containsKey(array)) {
            vaoMap.put(array, new VAOState());
        }
        StateTracker.tracker.vertexArrayObject = array;
    }

    static void deleteVAO(IntBuffer arrays) {
        for (int i = arrays.position(); i < arrays.limit(); ++i) {
            StateTracker.deleteVAO(arrays.get(i));
        }
    }

    static void deleteVAO(int array) {
        StateTracker.tracker.vaoMap.remove(array);
        if (StateTracker.tracker.vertexArrayObject == array) {
            StateTracker.tracker.vertexArrayObject = 0;
        }
    }

    private static class VAOState {
        int elementArrayBuffer;

        private VAOState() {
        }
    }
}

