/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;
import org.lwjgl.MemoryUtil;

public final class OESGetProgramBinary {
    public static final int GL_PROGRAM_BINARY_LENGTH_OES = 34625;
    public static final int GL_NUM_PROGRAM_BINARY_FORMATS_OES = 34814;
    public static final int GL_PROGRAM_BINARY_FORMATS_OES = 34815;

    private OESGetProgramBinary() {
    }

    static native void initNativeStubs() throws LWJGLException;

    public static void glGetProgramBinaryOES(int program, IntBuffer length, IntBuffer binaryFormat, ByteBuffer binary) {
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkBuffer(binaryFormat, 1);
        BufferChecks.checkDirect(binary);
        OESGetProgramBinary.nglGetProgramBinaryOES(program, binary.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(binaryFormat), MemoryUtil.getAddress(binary));
    }

    static native void nglGetProgramBinaryOES(int var0, int var1, long var2, long var4, long var6);

    public static void glProgramBinaryOES(int program, int binaryFormat, ByteBuffer binary) {
        BufferChecks.checkDirect(binary);
        OESGetProgramBinary.nglProgramBinaryOES(program, binaryFormat, MemoryUtil.getAddress(binary), binary.remaining());
    }

    static native void nglProgramBinaryOES(int var0, int var1, long var2, int var4);
}

