/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.opengles.ContextCapabilities;
import org.lwjgl.opengles.GLES20;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GLContext {
    private static final ThreadLocal<ContextCapabilities> current_capabilities = new ThreadLocal();
    private static CapabilitiesCacheEntry fast_path_cache = new CapabilitiesCacheEntry();
    private static final ThreadLocal<CapabilitiesCacheEntry> thread_cache_entries = new ThreadLocal();
    private static final Map<Object, ContextCapabilities> capability_cache = new WeakHashMap<Object, ContextCapabilities>();
    private static int gl_ref_count;
    private static boolean did_auto_load;

    public static ContextCapabilities getCapabilities() {
        CapabilitiesCacheEntry recent_cache_entry = fast_path_cache;
        if (recent_cache_entry.owner == Thread.currentThread()) {
            return recent_cache_entry.capabilities;
        }
        return GLContext.getThreadLocalCapabilities();
    }

    private static ContextCapabilities getThreadLocalCapabilities() {
        return current_capabilities.get();
    }

    static void setCapabilities(ContextCapabilities capabilities) {
        current_capabilities.set(capabilities);
        CapabilitiesCacheEntry thread_cache_entry = thread_cache_entries.get();
        if (thread_cache_entry == null) {
            thread_cache_entry = new CapabilitiesCacheEntry();
            thread_cache_entries.set(thread_cache_entry);
        }
        thread_cache_entry.owner = Thread.currentThread();
        thread_cache_entry.capabilities = capabilities;
        fast_path_cache = thread_cache_entry;
    }

    static void getSupportedExtensions(Set<String> supported_extensions) {
        String extensions_string;
        String version = GLES20.glGetString(7938);
        if (version == null) {
            throw new IllegalStateException("glGetString(GL_VERSION) returned null - possibly caused by missing current context.");
        }
        String VERSION_PREFIX = "OpenGL ES ";
        StringTokenizer version_tokenizer = new StringTokenizer(version.substring("OpenGL ES ".length()), ". ");
        int majorVersion = 0;
        int minorVersion = 0;
        try {
            majorVersion = Integer.parseInt(version_tokenizer.nextToken());
            minorVersion = Integer.parseInt(version_tokenizer.nextToken());
        }
        catch (NumberFormatException e) {
            LWJGLUtil.log("The major and/or minor OpenGL version is malformed: " + e.getMessage());
        }
        if (3 <= majorVersion) {
            supported_extensions.add("OpenGLES30");
        }
        if (2 <= majorVersion) {
            supported_extensions.add("OpenGLES20");
        }
        if ((extensions_string = GLES20.glGetString(7939)) == null) {
            throw new IllegalStateException("glGetString(GL_EXTENSIONS) returned null - is there a context current?");
        }
        StringTokenizer tokenizer = new StringTokenizer(extensions_string);
        while (tokenizer.hasMoreTokens()) {
            supported_extensions.add(tokenizer.nextToken());
        }
    }

    static void initNativeStubs(Class extension_class, Set<String> supported_extensions, String ext_name) {
        if (supported_extensions.contains(ext_name)) {
            try {
                GLContext.doInitNativeStubs(extension_class);
            }
            catch (LWJGLException e) {
                LWJGLUtil.log("Failed to initialize extension " + extension_class + " - exception: " + e);
                supported_extensions.remove(ext_name);
            }
        }
    }

    static void doInitNativeStubs(final Class<?> extension_class) throws LWJGLException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    Method init_stubs_method = extension_class.getDeclaredMethod("initNativeStubs", new Class[0]);
                    init_stubs_method.invoke(null, new Object[0]);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable c = e.getCause();
            if (c instanceof InvocationTargetException) {
                throw new LWJGLException(c.getCause());
            }
            throw new LWJGLException(c);
        }
    }

    public static synchronized void useContext(Object context) throws LWJGLException {
        if (context == null) {
            ContextCapabilities.unloadAllStubs();
            GLContext.setCapabilities(null);
            if (did_auto_load) {
                GLContext.unloadOpenGLLibrary();
            }
            return;
        }
        if (gl_ref_count == 0) {
            GLContext.loadOpenGLLibrary();
            did_auto_load = true;
        }
        try {
            ContextCapabilities capabilities = capability_cache.get(context);
            if (capabilities == null) {
                new ContextCapabilities();
                capability_cache.put(context, GLContext.getCapabilities());
            } else {
                GLContext.setCapabilities(capabilities);
            }
        }
        catch (LWJGLException e) {
            if (did_auto_load) {
                GLContext.unloadOpenGLLibrary();
            }
            throw e;
        }
    }

    public static synchronized void loadOpenGLLibrary() throws LWJGLException {
        if (gl_ref_count == 0) {
            GLContext.nLoadOpenGLLibrary();
        }
        ++gl_ref_count;
    }

    private static native void nLoadOpenGLLibrary() throws LWJGLException;

    public static synchronized void unloadOpenGLLibrary() {
        if (--gl_ref_count == 0 && LWJGLUtil.getPlatform() != 1) {
            GLContext.nUnloadOpenGLLibrary();
        }
    }

    private static native void nUnloadOpenGLLibrary();

    static native void resetNativeStubs(Class var0);

    static {
        Sys.initialize();
    }

    private static final class CapabilitiesCacheEntry {
        Thread owner;
        ContextCapabilities capabilities;

        private CapabilitiesCacheEntry() {
        }
    }
}

