/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengles.APIUtil;

public final class EXTDebugLabel {
    public static final int GL_BUFFER_OBJECT_EXT = 37201;
    public static final int GL_SHADER_OBJECT_EXT = 35656;
    public static final int GL_PROGRAM_OBJECT_EXT = 35648;
    public static final int GL_VERTEX_ARRAY_OBJECT_EXT = 37204;
    public static final int GL_QUERY_OBJECT_EXT = 37203;
    public static final int GL_PROGRAM_PIPELINE_OBJECT_EXT = 35407;

    private EXTDebugLabel() {
    }

    static native void initNativeStubs() throws LWJGLException;

    public static void glLabelObjectEXT(int type, int object, ByteBuffer label) {
        BufferChecks.checkDirect(label);
        EXTDebugLabel.nglLabelObjectEXT(type, object, label.remaining(), MemoryUtil.getAddress(label));
    }

    static native void nglLabelObjectEXT(int var0, int var1, int var2, long var3);

    public static void glLabelObjectEXT(int type, int object, CharSequence label) {
        EXTDebugLabel.nglLabelObjectEXT(type, object, label.length(), APIUtil.getBuffer(label));
    }

    public static void glGetObjectLabelEXT(int type, int object, IntBuffer length, ByteBuffer label) {
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        if (label != null) {
            BufferChecks.checkDirect(label);
        }
        EXTDebugLabel.nglGetObjectLabelEXT(type, object, label == null ? 0 : label.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddressSafe(label));
    }

    static native void nglGetObjectLabelEXT(int var0, int var1, int var2, long var3, long var5);

    public static String glGetObjectLabelEXT(int type, int object, int bufSize) {
        IntBuffer label_length = APIUtil.getLengths();
        ByteBuffer label = APIUtil.getBufferByte(bufSize);
        EXTDebugLabel.nglGetObjectLabelEXT(type, object, bufSize, MemoryUtil.getAddress0(label_length), MemoryUtil.getAddress(label));
        label.limit(label_length.get(0));
        return APIUtil.getString(label);
    }
}

