/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.IntBuffer;
import org.lwjgl.LWJGLException;
import org.lwjgl.PointerWrapperAbstract;
import org.lwjgl.opengles.APIUtil;
import org.lwjgl.opengles.EGL;
import org.lwjgl.opengles.EGLConfig;
import org.lwjgl.opengles.EGLDisplay;
import org.lwjgl.opengles.PowerManagementEventException;

public final class EGLSurface
extends PointerWrapperAbstract {
    private final EGLDisplay display;
    private final EGLConfig config;
    private boolean destroyed;

    EGLSurface(EGLDisplay display, EGLConfig config, long pointer) {
        super(pointer);
        if (!display.isInitialized()) {
            throw new IllegalStateException("Invalid EGL display specified.");
        }
        this.display = display;
        this.config = config;
    }

    public EGLDisplay getDisplay() {
        return this.display;
    }

    public EGLConfig getConfig() {
        return this.config;
    }

    private void checkDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException("The EGL surface has been destroyed.");
        }
    }

    public void destroy() throws LWJGLException {
        EGL.eglDestroySurface(this.display, this);
        this.destroyed = true;
    }

    void setAttribute(int attribute, int value) throws LWJGLException {
        this.checkDestroyed();
        EGL.eglSurfaceAttrib(this.display, this, attribute, value);
    }

    public int getAttribute(int attribute) throws LWJGLException {
        this.checkDestroyed();
        IntBuffer value = APIUtil.getBufferInt();
        EGL.eglQuerySurface(this.display, this, attribute, value);
        return value.get(0);
    }

    public void swapBuffers() throws LWJGLException, PowerManagementEventException {
        this.checkDestroyed();
        EGL.eglSwapBuffers(this.display, this);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof EGLSurface)) {
            return false;
        }
        return this.getPointer() == ((EGLSurface)obj).getPointer();
    }
}

