/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import org.lwjgl.LWJGLException;
import org.lwjgl.PointerWrapperAbstract;
import org.lwjgl.opengles.EGL;
import org.lwjgl.opengles.EGLDisplay;
import org.lwjgl.opengles.PixelFormat;

public final class EGLConfig
extends PointerWrapperAbstract {
    private final EGLDisplay display;
    private final int configID;

    EGLConfig(EGLDisplay display, long pointer) throws LWJGLException {
        super(pointer);
        this.display = display;
        this.configID = this.getAttribute(12328);
    }

    public EGLDisplay getDisplay() {
        return this.display;
    }

    public int getConfigID() {
        return this.configID;
    }

    public int getAttribute(int attribute) throws LWJGLException {
        return EGL.eglGetConfigAttrib(this.display, this, attribute);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof EGLConfig)) {
            return false;
        }
        return this.getPointer() == ((EGLConfig)obj).getPointer();
    }

    public String toString() {
        PixelFormat.Attrib[] attribEnums;
        StringBuilder sb = new StringBuilder(512);
        sb.append("EGLConfig (").append(this.configID).append(")");
        sb.append("\n------------");
        try {
            sb.append("\nEGL_LEVEL").append(": ").append(this.getAttribute(12329));
            sb.append("\nEGL_RENDERABLE_TYPE").append(": ").append(Integer.toBinaryString(this.getAttribute(12352)));
            sb.append("\nEGL_NATIVE_RENDERABLE").append(": ").append(this.getAttribute(12333) == 1);
            sb.append("\nEGL_SURFACE_TYPE").append(": ").append(Integer.toBinaryString(this.getAttribute(12339)));
        }
        catch (LWJGLException lWJGLException) {
            // empty catch block
        }
        for (PixelFormat.Attrib attribEnum : attribEnums = PixelFormat.Attrib.values()) {
            if (attribEnum.isSurfaceAttrib()) continue;
            try {
                int attrib = this.getAttribute(attribEnum.getEGLAttrib());
                sb.append("\nEGL_").append(attribEnum.name()).append(": ").append(attrib);
            }
            catch (LWJGLException lWJGLException) {
                // empty catch block
            }
        }
        return sb.toString();
    }
}

