/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLException;
import org.lwjgl.MemoryUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.APIUtil;
import org.lwjgl.opengles.EGLConfig;
import org.lwjgl.opengles.EGLContext;
import org.lwjgl.opengles.EGLDisplay;
import org.lwjgl.opengles.EGLSurface;
import org.lwjgl.opengles.PowerManagementEventException;
import org.lwjgl.opengles.Util;

public final class EGL {
    public static final int EGL_FALSE = 0;
    public static final int EGL_TRUE = 1;
    public static final int EGL_DEFAULT_DISPLAY = 0;
    public static final int EGL_NO_CONTEXT = 0;
    public static final int EGL_NO_DISPLAY = 0;
    public static final int EGL_NO_SURFACE = 0;
    public static final int EGL_DONT_CARE = -1;
    public static final int EGL_SUCCESS = 12288;
    public static final int EGL_NOT_INITIALIZED = 12289;
    public static final int EGL_BAD_ACCESS = 12290;
    public static final int EGL_BAD_ALLOC = 12291;
    public static final int EGL_BAD_ATTRIBUTE = 12292;
    public static final int EGL_BAD_CONFIG = 12293;
    public static final int EGL_BAD_CONTEXT = 12294;
    public static final int EGL_BAD_CURRENT_SURFACE = 12295;
    public static final int EGL_BAD_DISPLAY = 12296;
    public static final int EGL_BAD_MATCH = 12297;
    public static final int EGL_BAD_NATIVE_PIXMAP = 12298;
    public static final int EGL_BAD_NATIVE_WINDOW = 12299;
    public static final int EGL_BAD_PARAMETER = 12300;
    public static final int EGL_BAD_SURFACE = 12301;
    public static final int EGL_CONTEXT_LOST = 12302;
    public static final int EGL_BUFFER_SIZE = 12320;
    public static final int EGL_ALPHA_SIZE = 12321;
    public static final int EGL_BLUE_SIZE = 12322;
    public static final int EGL_GREEN_SIZE = 12323;
    public static final int EGL_RED_SIZE = 12324;
    public static final int EGL_DEPTH_SIZE = 12325;
    public static final int EGL_STENCIL_SIZE = 12326;
    public static final int EGL_CONFIG_CAVEAT = 12327;
    public static final int EGL_CONFIG_ID = 12328;
    public static final int EGL_LEVEL = 12329;
    public static final int EGL_MAX_PBUFFER_HEIGHT = 12330;
    public static final int EGL_MAX_PBUFFER_PIXELS = 12331;
    public static final int EGL_MAX_PBUFFER_WIDTH = 12332;
    public static final int EGL_NATIVE_RENDERABLE = 12333;
    public static final int EGL_NATIVE_VISUAL_ID = 12334;
    public static final int EGL_NATIVE_VISUAL_TYPE = 12335;
    public static final int EGL_SAMPLES = 12337;
    public static final int EGL_SAMPLE_BUFFERS = 12338;
    public static final int EGL_SURFACE_TYPE = 12339;
    public static final int EGL_TRANSPARENT_TYPE = 12340;
    public static final int EGL_TRANSPARENT_BLUE_VALUE = 12341;
    public static final int EGL_TRANSPARENT_GREEN_VALUE = 12342;
    public static final int EGL_TRANSPARENT_RED_VALUE = 12343;
    public static final int EGL_NONE = 12344;
    public static final int EGL_BIND_TO_TEXTURE_RGB = 12345;
    public static final int EGL_BIND_TO_TEXTURE_RGBA = 12346;
    public static final int EGL_MIN_SWAP_INTERVAL = 12347;
    public static final int EGL_MAX_SWAP_INTERVAL = 12348;
    public static final int EGL_LUMINANCE_SIZE = 12349;
    public static final int EGL_ALPHA_MASK_SIZE = 12350;
    public static final int EGL_COLOR_BUFFER_TYPE = 12351;
    public static final int EGL_RENDERABLE_TYPE = 12352;
    public static final int EGL_MATCH_NATIVE_PIXMAP = 12353;
    public static final int EGL_CONFORMANT = 12354;
    public static final int EGL_SLOW_CONFIG = 12368;
    public static final int EGL_NON_CONFORMANT_CONFIG = 12369;
    public static final int EGL_TRANSPARENT_RGB = 12370;
    public static final int EGL_RGB_BUFFER = 12430;
    public static final int EGL_LUMINANCE_BUFFER = 12431;
    public static final int EGL_NO_TEXTURE = 12380;
    public static final int EGL_TEXTURE_RGB = 12381;
    public static final int EGL_TEXTURE_RGBA = 12382;
    public static final int EGL_TEXTURE_2D = 12383;
    public static final int EGL_PBUFFER_BIT = 1;
    public static final int EGL_PIXMAP_BIT = 2;
    public static final int EGL_WINDOW_BIT = 4;
    public static final int EGL_VG_COLORSPACE_LINEAR_BIT = 32;
    public static final int EGL_VG_ALPHA_FORMAT_PRE_BIT = 64;
    public static final int EGL_MULTISAMPLE_RESOLVE_BOX_BIT = 512;
    public static final int EGL_SWAP_BEHAVIOR_PRESERVED_BIT = 1024;
    public static final int EGL_OPENGL_ES_BIT = 1;
    public static final int EGL_OPENVG_BIT = 2;
    public static final int EGL_OPENGL_ES2_BIT = 4;
    public static final int EGL_OPENGL_BIT = 8;
    public static final int EGL_VENDOR = 12371;
    public static final int EGL_VERSION = 12372;
    public static final int EGL_EXTENSIONS = 12373;
    public static final int EGL_CLIENT_APIS = 12429;
    public static final int EGL_HEIGHT = 12374;
    public static final int EGL_WIDTH = 12375;
    public static final int EGL_LARGEST_PBUFFER = 12376;
    public static final int EGL_TEXTURE_FORMAT = 12416;
    public static final int EGL_TEXTURE_TARGET = 12417;
    public static final int EGL_MIPMAP_TEXTURE = 12418;
    public static final int EGL_MIPMAP_LEVEL = 12419;
    public static final int EGL_RENDER_BUFFER = 12422;
    public static final int EGL_VG_COLORSPACE = 12423;
    public static final int EGL_VG_ALPHA_FORMAT = 12424;
    public static final int EGL_HORIZONTAL_RESOLUTION = 12432;
    public static final int EGL_VERTICAL_RESOLUTION = 12433;
    public static final int EGL_PIXEL_ASPECT_RATIO = 12434;
    public static final int EGL_SWAP_BEHAVIOR = 12435;
    public static final int EGL_MULTISAMPLE_RESOLVE = 12441;
    public static final int EGL_BACK_BUFFER = 12420;
    public static final int EGL_SINGLE_BUFFER = 12421;
    public static final int EGL_VG_COLORSPACE_sRGB = 12425;
    public static final int EGL_VG_COLORSPACE_LINEAR = 12426;
    public static final int EGL_VG_ALPHA_FORMAT_NONPRE = 12427;
    public static final int EGL_VG_ALPHA_FORMAT_PRE = 12428;
    public static final int EGL_DISPLAY_SCALING = 10000;
    public static final int EGL_UNKNOWN = -1;
    public static final int EGL_BUFFER_PRESERVED = 12436;
    public static final int EGL_BUFFER_DESTROYED = 12437;
    static final int EGL_OPENVG_IMAGE = 12438;
    public static final int EGL_CONTEXT_CLIENT_TYPE = 12439;
    public static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    public static final int EGL_MULTISAMPLE_RESOLVE_DEFAULT = 12442;
    public static final int EGL_MULTISAMPLE_RESOLVE_BOX = 12443;
    public static final int EGL_OPENGL_ES_API = 12448;
    public static final int EGL_OPENVG_API = 12449;
    public static final int EGL_OPENGL_API = 12450;
    public static final int EGL_DRAW = 12377;
    public static final int EGL_READ = 12378;
    static final int EGL_CORE_NATIVE_ENGINE = 12379;

    private EGL() {
    }

    public static native int eglGetError();

    public static EGLDisplay eglGetDisplay(long display_id) throws LWJGLException {
        long pointer = EGL.neglGetDisplay(display_id);
        if (pointer == 0L) {
            throw new LWJGLException("Failed to get EGL display from native display handle: " + display_id);
        }
        return new EGLDisplay(pointer);
    }

    private static native long neglGetDisplay(long var0);

    static void eglInitialize(EGLDisplay dpy, IntBuffer version) throws LWJGLException {
        BufferChecks.checkBuffer(version, 2);
        if (!EGL.neglInitialize(dpy.getPointer(), MemoryUtil.getAddress(version))) {
            EGL.throwEGLError("Failed to initialize EGL display.");
        }
    }

    private static native boolean neglInitialize(long var0, long var2);

    static void eglTerminate(EGLDisplay dpy) throws LWJGLException {
        if (!EGL.neglTerminate(dpy.getPointer())) {
            EGL.throwEGLError("Failed to terminate EGL display.");
        }
    }

    private static native boolean neglTerminate(long var0);

    public static String eglQueryString(EGLDisplay dpy, int name) {
        return EGL.neglQueryString(dpy.getPointer(), name);
    }

    private static native String neglQueryString(long var0, int var2);

    static int eglGetConfigsNum(EGLDisplay dpy) throws LWJGLException {
        IntBuffer num_config = APIUtil.getBufferInt();
        if (!EGL.neglGetConfigs(dpy.getPointer(), 0L, 0, MemoryUtil.getAddress0(num_config))) {
            EGL.throwEGLError("Failed to get EGL configs.");
        }
        return num_config.get(0);
    }

    static EGLConfig[] eglGetConfigs(EGLDisplay dpy, EGLConfig[] configs, IntBuffer num_config) throws LWJGLException {
        BufferChecks.checkBuffer(num_config, 1);
        if (configs == null) {
            if (!EGL.neglGetConfigs(dpy.getPointer(), 0L, 0, MemoryUtil.getAddress(num_config))) {
                EGL.throwEGLError("Failed to get number of available EGL configs.");
            }
            configs = new EGLConfig[num_config.get(num_config.position())];
        }
        PointerBuffer configs_buffer = APIUtil.getBufferPointer(configs.length);
        if (!EGL.neglGetConfigs(dpy.getPointer(), MemoryUtil.getAddress0(configs_buffer), configs.length, MemoryUtil.getAddress(num_config))) {
            EGL.throwEGLError("Failed to get EGL configs.");
        }
        int config_size = num_config.get(num_config.position());
        for (int i = 0; i < config_size; ++i) {
            configs[i] = new EGLConfig(dpy, configs_buffer.get(i));
        }
        return configs;
    }

    private static native boolean neglGetConfigs(long var0, long var2, int var4, long var5);

    static int eglChooseConfigNum(EGLDisplay dpy, IntBuffer attrib_list) throws LWJGLException {
        EGL.checkAttribList(attrib_list);
        IntBuffer num_config = APIUtil.getBufferInt();
        if (!EGL.neglChooseConfig(dpy.getPointer(), MemoryUtil.getAddressSafe(attrib_list), 0L, 0, MemoryUtil.getAddress0(num_config))) {
            EGL.throwEGLError("Failed to get EGL configs.");
        }
        return num_config.get(0);
    }

    static EGLConfig[] eglChooseConfig(EGLDisplay dpy, IntBuffer attrib_list, EGLConfig[] configs, IntBuffer num_config) throws LWJGLException {
        int config_size;
        EGL.checkAttribList(attrib_list);
        BufferChecks.checkBuffer(num_config, 1);
        if (configs == null) {
            if (!EGL.neglChooseConfig(dpy.getPointer(), MemoryUtil.getAddressSafe(attrib_list), 0L, 0, MemoryUtil.getAddress(num_config))) {
                EGL.throwEGLError("Failed to get number of available EGL configs.");
            }
            config_size = num_config.get(num_config.position());
        } else {
            config_size = configs.length;
        }
        PointerBuffer configs_buffer = APIUtil.getBufferPointer(config_size);
        if (!EGL.neglChooseConfig(dpy.getPointer(), MemoryUtil.getAddressSafe(attrib_list), MemoryUtil.getAddress0(configs_buffer), config_size, MemoryUtil.getAddress(num_config))) {
            EGL.throwEGLError("Failed to choose EGL config.");
        }
        config_size = num_config.get(num_config.position());
        if (configs == null) {
            configs = new EGLConfig[config_size];
        }
        for (int i = 0; i < config_size; ++i) {
            configs[i] = new EGLConfig(dpy, configs_buffer.get(i));
        }
        return configs;
    }

    private static native boolean neglChooseConfig(long var0, long var2, long var4, int var6, long var7);

    static int eglGetConfigAttrib(EGLDisplay dpy, EGLConfig config, int attribute) throws LWJGLException {
        IntBuffer value = APIUtil.getBufferInt();
        if (!EGL.neglGetConfigAttrib(dpy.getPointer(), config.getPointer(), attribute, MemoryUtil.getAddress(value))) {
            EGL.throwEGLError("Failed to get EGL config attribute.");
        }
        return value.get(0);
    }

    private static native boolean neglGetConfigAttrib(long var0, long var2, int var4, long var5);

    static EGLSurface eglCreateWindowSurface(EGLDisplay dpy, EGLConfig config, long win, IntBuffer attrib_list) throws LWJGLException {
        EGL.checkAttribList(attrib_list);
        long pointer = EGL.neglCreateWindowSurface(dpy.getPointer(), config.getPointer(), win, MemoryUtil.getAddressSafe(attrib_list));
        if (pointer == 0L) {
            EGL.throwEGLError("Failed to create EGL window surface.");
        }
        return new EGLSurface(dpy, config, pointer);
    }

    private static native long neglCreateWindowSurface(long var0, long var2, long var4, long var6);

    static EGLSurface eglCreatePbufferSurface(EGLDisplay dpy, EGLConfig config, IntBuffer attrib_list) throws LWJGLException {
        EGL.checkAttribList(attrib_list);
        long pointer = EGL.neglCreatePbufferSurface(dpy.getPointer(), config.getPointer(), MemoryUtil.getAddressSafe(attrib_list));
        if (pointer == 0L) {
            EGL.throwEGLError("Failed to create EGL pbuffer surface.");
        }
        return new EGLSurface(dpy, config, pointer);
    }

    private static native long neglCreatePbufferSurface(long var0, long var2, long var4);

    static void eglSurfaceAttrib(EGLDisplay dpy, EGLSurface surface, int attribute, int value) throws LWJGLException {
        if (!EGL.neglSurfaceAttrib(dpy.getPointer(), surface.getPointer(), attribute, value)) {
            EGL.throwEGLError("Failed to set surface attribute.");
        }
    }

    private static native boolean neglSurfaceAttrib(long var0, long var2, int var4, int var5);

    static void eglDestroySurface(EGLDisplay dpy, EGLSurface surface) throws LWJGLException {
        if (!EGL.neglDestroySurface(dpy.getPointer(), surface.getPointer())) {
            EGL.throwEGLError("Failed to destroy EGL surface.");
        }
    }

    private static native boolean neglDestroySurface(long var0, long var2);

    public static void eglQuerySurface(EGLDisplay dpy, EGLSurface surface, int attribute, IntBuffer value) throws LWJGLException {
        BufferChecks.checkBuffer(value, 1);
        if (!EGL.neglQuerySurface(dpy.getPointer(), surface.getPointer(), attribute, MemoryUtil.getAddress(value))) {
            EGL.throwEGLError("Failed to query surface attribute.");
        }
    }

    private static native boolean neglQuerySurface(long var0, long var2, int var4, long var5);

    public static native boolean eglBindAPI(int var0);

    public static native int eglQueryAPI();

    static native boolean eglReleaseThread();

    static void eglSwapInterval(EGLDisplay dpy, int interval) throws LWJGLException {
        if (!EGL.neglSwapInterval(dpy.getPointer(), interval)) {
            EGL.throwEGLError("Failed to set swap interval.");
        }
    }

    private static native boolean neglSwapInterval(long var0, int var2);

    static EGLContext eglCreateContext(EGLDisplay dpy, EGLConfig config, EGLContext share_context, IntBuffer attrib_list) throws LWJGLException {
        EGL.checkAttribList(attrib_list);
        long pointer = EGL.neglCreateContext(dpy.getPointer(), config.getPointer(), share_context == null ? 0L : share_context.getPointer(), MemoryUtil.getAddressSafe(attrib_list));
        if (pointer == 0L) {
            EGL.throwEGLError("Failed to create EGL context.");
        }
        return new EGLContext(dpy, config, pointer);
    }

    private static native long neglCreateContext(long var0, long var2, long var4, long var6);

    static void eglDestroyContext(EGLDisplay dpy, EGLContext ctx) throws LWJGLException {
        if (!EGL.neglDestroyContext(dpy.getPointer(), ctx.getPointer())) {
            EGL.throwEGLError("Failed to destroy context.");
        }
    }

    private static native boolean neglDestroyContext(long var0, long var2);

    static void eglMakeCurrent(EGLDisplay dpy, EGLSurface draw, EGLSurface read, EGLContext ctx) throws LWJGLException, PowerManagementEventException {
        if (!EGL.neglMakeCurrent(dpy.getPointer(), draw == null ? 0L : draw.getPointer(), read == null ? 0L : read.getPointer(), ctx == null ? 0L : ctx.getPointer())) {
            int error = EGL.eglGetError();
            if (error == 12302) {
                throw new PowerManagementEventException();
            }
            EGL.throwEGLError("Failed to change the current context.", error);
        }
    }

    public static void eglReleaseCurrent(EGLDisplay dpy) throws LWJGLException, PowerManagementEventException {
        EGL.eglMakeCurrent(dpy, null, null, null);
    }

    private static native boolean neglMakeCurrent(long var0, long var2, long var4, long var6);

    public static EGLContext eglGetCurrentContext() throws LWJGLException {
        long ctx = EGL.neglGetCurrentContext();
        if (ctx == 0L) {
            return null;
        }
        EGLDisplay display = EGL.eglGetCurrentDisplay();
        IntBuffer attrib_list = APIUtil.getBufferInt();
        EGL.neglQueryContext(display.getPointer(), ctx, 12328, MemoryUtil.getAddress0(attrib_list));
        EGLConfig config = EGL.getEGLConfig(display, attrib_list);
        return new EGLContext(display, config, ctx);
    }

    public static boolean eglIsCurrentContext(EGLContext context) {
        return EGL.neglGetCurrentContext() == context.getPointer();
    }

    private static native long neglGetCurrentContext();

    public static EGLSurface eglGetCurrentSurface(int readdraw) throws LWJGLException {
        long surface = EGL.neglGetCurrentSurface(readdraw);
        if (surface == 0L) {
            return null;
        }
        EGLDisplay display = EGL.eglGetCurrentDisplay();
        IntBuffer attrib_list = APIUtil.getBufferInt();
        if (!EGL.neglQuerySurface(display.getPointer(), surface, 12328, MemoryUtil.getAddress0(attrib_list))) {
            EGL.throwEGLError("Failed to query surface EGL config ID.");
        }
        EGLConfig config = EGL.getEGLConfig(display, attrib_list);
        return new EGLSurface(display, config, surface);
    }

    private static native long neglGetCurrentSurface(int var0);

    public static EGLDisplay eglGetCurrentDisplay() throws LWJGLException {
        return new EGLDisplay(EGL.neglGetCurrentDisplay());
    }

    private static native long neglGetCurrentDisplay();

    public static void eglQueryContext(EGLDisplay dpy, EGLContext ctx, int attribute, IntBuffer value) throws LWJGLException {
        BufferChecks.checkBuffer(value, 1);
        if (!EGL.neglQueryContext(dpy.getPointer(), ctx.getPointer(), attribute, MemoryUtil.getAddress(value))) {
            EGL.throwEGLError("Failed to query context attribute.");
        }
    }

    private static native boolean neglQueryContext(long var0, long var2, int var4, long var5);

    public static native boolean eglWaitClient();

    public static native boolean eglWaitGL();

    public static native boolean eglWaitNative(int var0);

    static void eglSwapBuffers(EGLDisplay dpy, EGLSurface surface) throws LWJGLException, PowerManagementEventException {
        if (!EGL.neglSwapBuffers(dpy.getPointer(), surface.getPointer())) {
            int error = EGL.eglGetError();
            if (error == 12302) {
                throw new PowerManagementEventException();
            }
            EGL.throwEGLError("Failed to swap buffers.", error);
        }
    }

    private static native boolean neglSwapBuffers(long var0, long var2);

    static void checkAttribList(IntBuffer attrib_list) {
        if (attrib_list == null) {
            return;
        }
        if (attrib_list.remaining() % 2 != 1) {
            throw new IllegalArgumentException("Invalid number of values in attribute list.");
        }
        if (attrib_list.get(attrib_list.limit() - 1) != 12344) {
            throw new IllegalArgumentException("The attribute list is not terminated with EGL_NONE.");
        }
    }

    private static EGLConfig getEGLConfig(EGLDisplay dpy, IntBuffer attrib_list) throws LWJGLException {
        int configID = attrib_list.get(0);
        attrib_list.put(0, 12328).put(1, configID).put(2, 12344);
        PointerBuffer configs_buffer = APIUtil.getBufferPointer(1);
        if (!EGL.neglChooseConfig(dpy.getPointer(), MemoryUtil.getAddress(attrib_list), MemoryUtil.getAddress0(configs_buffer), 1, MemoryUtil.getAddress(attrib_list, 3))) {
            EGL.throwEGLError("Failed to choose EGL config.");
        }
        return new EGLConfig(dpy, configs_buffer.get(0));
    }

    static void throwEGLError(String msg) throws LWJGLException {
        EGL.throwEGLError(msg, EGL.eglGetError());
    }

    static void throwEGLError(String msg, int error) throws LWJGLException {
        if (error != 12288) {
            msg = msg + " EGL error: " + Util.translateEGLErrorString(error);
        }
        throw new LWJGLException(msg);
    }
}

