/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.examples.spaceinvaders;

import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.util.WaveData;

public class SoundManager {
    private int[] buffers = new int[256];
    private int[] sources;
    private IntBuffer scratchBuffer = BufferUtils.createIntBuffer(256);
    private boolean soundOutput;
    private int bufferIndex;
    private int sourceIndex;

    public void playEffect(int buffer) {
        if (this.soundOutput) {
            int channel = this.sources[this.sourceIndex++ % (this.sources.length - 1)];
            AL10.alSourcei(channel, 4105, this.buffers[buffer]);
            AL10.alSourcePlay(channel);
        }
    }

    public void playSound(int buffer) {
        if (this.soundOutput) {
            AL10.alSourcei(this.sources[this.sources.length - 1], 4105, this.buffers[buffer]);
            AL10.alSourcePlay(this.sources[this.sources.length - 1]);
        }
    }

    public boolean isPlayingSound() {
        return AL10.alGetSourcei(this.sources[this.sources.length - 1], 4112) == 4114;
    }

    public void initialize(int channels) {
        try {
            AL.create();
            this.scratchBuffer.limit(channels);
            AL10.alGenSources(this.scratchBuffer);
            this.scratchBuffer.rewind();
            this.sources = new int[channels];
            this.scratchBuffer.get(this.sources);
            if (AL10.alGetError() != 0) {
                throw new LWJGLException("Unable to allocate " + channels + " sources");
            }
            this.soundOutput = true;
        }
        catch (LWJGLException le) {
            le.printStackTrace();
            System.out.println("Sound disabled");
        }
    }

    public int addSound(String path) {
        this.scratchBuffer.rewind().position(0).limit(1);
        AL10.alGenBuffers(this.scratchBuffer);
        this.buffers[this.bufferIndex] = this.scratchBuffer.get(0);
        WaveData wavefile = WaveData.create("spaceinvaders/" + path);
        AL10.alBufferData(this.buffers[this.bufferIndex], wavefile.format, wavefile.data, wavefile.samplerate);
        wavefile.dispose();
        return this.bufferIndex++;
    }

    public void destroy() {
        if (this.soundOutput) {
            this.scratchBuffer.position(0).limit(this.sources.length);
            this.scratchBuffer.put(this.sources).flip();
            AL10.alSourceStop(this.scratchBuffer);
            AL10.alDeleteSources(this.scratchBuffer);
            this.scratchBuffer.position(0).limit(this.bufferIndex);
            this.scratchBuffer.put(this.buffers, 0, this.bufferIndex).flip();
            AL10.alDeleteBuffers(this.scratchBuffer);
            AL.destroy();
        }
    }
}

